/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.request;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningParametersResolver;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.request.RequestHttpObject;
import se.litsec.opensaml.utils.SignatureUtils;

public class RedirectRequestHttpObject<T extends RequestAbstractType>
extends HTTPRedirectDeflateEncoder
implements RequestHttpObject<T> {
    private static final Logger logger = LoggerFactory.getLogger(RedirectRequestHttpObject.class);
    private T request;
    private String sendUrl;
    private Map<String, String> httpHeaders = new HashMap<String, String>();

    @Deprecated
    public RedirectRequestHttpObject(T request, String relayState, X509Credential signatureCredentials, String endpoint) throws MessageEncodingException, SignatureException {
        this(request, relayState, signatureCredentials, endpoint, null);
    }

    public RedirectRequestHttpObject(T request, String relayState, X509Credential signatureCredentials, String endpoint, EntityDescriptor recipientMetadata) throws MessageEncodingException, SignatureException {
        this(request, relayState, signatureCredentials, endpoint, recipientMetadata, null);
    }

    public RedirectRequestHttpObject(T request, String relayState, X509Credential signatureCredentials, String endpoint, EntityDescriptor recipientMetadata, SignatureSigningConfiguration defaultSignatureSigningConfiguration) throws MessageEncodingException, SignatureException {
        this.request = request;
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage(request);
        ((SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true)).setRelayState(relayState);
        if (signatureCredentials != null) {
            SignatureSigningConfiguration peerConfig = SignatureUtils.getSignaturePreferences(recipientMetadata);
            SignatureSigningConfiguration[] configs = new SignatureSigningConfiguration[2 + (peerConfig != null ? 1 : 0)];
            int pos = 0;
            if (peerConfig != null) {
                configs[pos++] = peerConfig;
            }
            configs[pos++] = defaultSignatureSigningConfiguration != null ? defaultSignatureSigningConfiguration : SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration();
            BasicSignatureSigningConfiguration signatureCreds = new BasicSignatureSigningConfiguration();
            signatureCreds.setSigningCredentials(Collections.singletonList(signatureCredentials));
            configs[pos] = signatureCreds;
            BasicSignatureSigningParametersResolver signatureParametersResolver = new BasicSignatureSigningParametersResolver();
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(configs)});
            try {
                SignatureSigningParameters parameters = signatureParametersResolver.resolveSingle(criteriaSet);
                ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(parameters);
            }
            catch (ResolverException e) {
                throw new SignatureException((Exception)((Object)e));
            }
        }
        this.removeSignature((SAMLObject)this.request);
        String encodedMessage = this.deflateAndBase64Encode((SAMLObject)this.request);
        URLBuilder urlBuilder = null;
        try {
            urlBuilder = new URLBuilder(endpoint);
            List queryParams = urlBuilder.getQueryParams();
            this.removeDisallowedQueryParams(queryParams);
            if (!queryParams.isEmpty()) {
                ArrayList qp = new ArrayList(queryParams);
                queryParams.clear();
                String tmpSendUrl = this.buildRedirectURL(messageContext, urlBuilder.buildURL(), encodedMessage);
                urlBuilder = new URLBuilder(tmpSendUrl);
                queryParams = urlBuilder.getQueryParams();
                queryParams.addAll(0, qp);
                this.sendUrl = urlBuilder.buildURL();
            } else {
                this.sendUrl = this.buildRedirectURL(messageContext, endpoint, encodedMessage);
            }
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpoint + " is not a valid URL", (Exception)e);
        }
        logger.trace("Redirect URL is {}", (Object)this.sendUrl);
        this.httpHeaders.put("Cache-control", "no-cache, no-store");
        this.httpHeaders.put("Pragma", "no-cache");
    }

    @Override
    public String getSendUrl() {
        return this.sendUrl;
    }

    @Override
    public String getMethod() {
        return "GET";
    }

    @Override
    public Map<String, String> getRequestParameters() {
        return null;
    }

    @Override
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public T getRequest() {
        return this.request;
    }

    public String toString() {
        return String.format("request-type='%s', sendUrl='%s', httpHeaders=%s", this.request.getClass().getSimpleName(), this.sendUrl, this.httpHeaders);
    }
}

