/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.request;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPPostEncoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.litsec.opensaml.saml2.common.request.RequestHttpObject;
import se.litsec.opensaml.utils.SignatureUtils;

public class PostRequestHttpObject<T extends RequestAbstractType>
extends HTTPPostEncoder
implements RequestHttpObject<T> {
    private static final Logger logger = LoggerFactory.getLogger(PostRequestHttpObject.class);
    private T request;
    private String sendUrl;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private Map<String, String> postParameters = new HashMap<String, String>();

    @Deprecated
    public PostRequestHttpObject(T request, String relayState, X509Credential signatureCredentials, String endpoint) throws MessageEncodingException, SignatureException {
        this(request, relayState, signatureCredentials, endpoint, null);
    }

    public PostRequestHttpObject(T request, String relayState, X509Credential signatureCredentials, String endpoint, EntityDescriptor recipientMetadata) throws MessageEncodingException, SignatureException {
        this(request, relayState, signatureCredentials, endpoint, recipientMetadata, null);
    }

    public PostRequestHttpObject(T request, String relayState, X509Credential signatureCredentials, String endpoint, EntityDescriptor recipientMetadata, SignatureSigningConfiguration defaultSignatureSigningConfiguration) throws MessageEncodingException, SignatureException {
        this.request = request;
        MessageContext context = new MessageContext();
        context.setMessage(request);
        this.sendUrl = endpoint;
        if (signatureCredentials != null) {
            logger.trace("Signing SAML Request message ...");
            SignatureUtils.sign(this.request, (Credential)signatureCredentials, defaultSignatureSigningConfiguration != null ? defaultSignatureSigningConfiguration : SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration(), recipientMetadata);
        }
        logger.trace("Marshalling and Base64 encoding SAML message");
        Element domMessage = this.marshallMessage((XMLObject)context.getMessage());
        try {
            String messageXML = SerializeSupport.nodeToString((Node)domMessage);
            String encodedMessage = Base64Support.encode((byte[])messageXML.getBytes("UTF-8"), (boolean)false);
            this.postParameters.put("SAMLRequest", encodedMessage);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UTF-8 encoding is not supported, this VM is not Java compliant.");
            throw new MessageEncodingException("Unable to encode message, UTF-8 encoding is not supported");
        }
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            String encodedRelayState = HTMLEncoder.encodeForHTMLAttribute((String)relayState);
            logger.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
            this.postParameters.put("RelayState", encodedRelayState);
        }
        this.httpHeaders.put("Cache-control", "no-cache, no-store");
        this.httpHeaders.put("Pragma", "no-cache");
    }

    @Override
    public String getSendUrl() {
        return this.sendUrl;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getRequestParameters() {
        return this.postParameters;
    }

    @Override
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public T getRequest() {
        return this.request;
    }

    public String toString() {
        return String.format("request-type='%s', sendUrl='%s', httpHeaders='%s, postParameters=%s", this.request.getClass().getSimpleName(), this.sendUrl, this.httpHeaders, this.postParameters);
    }
}

