/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.request;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import se.litsec.opensaml.saml2.common.request.PostRequestHttpObject;
import se.litsec.opensaml.saml2.common.request.RedirectRequestHttpObject;
import se.litsec.opensaml.saml2.common.request.RequestGenerationException;
import se.litsec.opensaml.saml2.common.request.RequestGenerator;
import se.litsec.opensaml.saml2.common.request.RequestGeneratorInput;
import se.litsec.opensaml.saml2.common.request.RequestHttpObject;
import se.litsec.opensaml.saml2.metadata.PeerMetadataResolver;

public abstract class AbstractRequestGenerator<T extends RequestAbstractType, I extends RequestGeneratorInput>
implements RequestGenerator<T, I>,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(AbstractRequestGenerator.class);
    private String entityID;
    private String name;
    private X509Credential signingCredentials;
    private Random randomizer = new SecureRandom(String.valueOf(System.currentTimeMillis()).getBytes());

    public AbstractRequestGenerator(String entityID) {
        this.entityID = entityID;
        if (this.entityID == null || this.entityID.trim().isEmpty()) {
            throw new IllegalArgumentException("entityID must not be null or empty");
        }
    }

    protected EntityDescriptor getPeerMetadata(RequestGeneratorInput input, PeerMetadataResolver metadataResolver) throws RequestGenerationException {
        EntityDescriptor metadata = metadataResolver.getMetadata(input.getPeerEntityID());
        if (metadata == null) {
            throw new RequestGenerationException("No metadata available for " + input.getPeerEntityID());
        }
        return metadata;
    }

    @Deprecated
    protected RequestHttpObject<T> buildRequestHttpObject(T request, I input, String binding, String destination) throws RequestGenerationException {
        return this.buildRequestHttpObject(request, input, binding, destination, null);
    }

    protected RequestHttpObject<T> buildRequestHttpObject(T request, I input, String binding, String destination, EntityDescriptor recipientMetadata) throws RequestGenerationException {
        return this.buildRequestHttpObject(request, input, binding, destination, recipientMetadata, null);
    }

    protected RequestHttpObject<T> buildRequestHttpObject(T request, I input, String binding, String destination, EntityDescriptor recipientMetadata, SignatureSigningConfiguration defaultSignatureSigningConfiguration) throws RequestGenerationException {
        X509Credential signCred = input.getOverrideSigningCredential();
        if (signCred == null) {
            signCred = this.getSigningCredentials();
        }
        try {
            if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(binding)) {
                return new RedirectRequestHttpObject<T>(request, input.getRelayState(), signCred, destination, recipientMetadata, defaultSignatureSigningConfiguration);
            }
            if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(binding)) {
                return new PostRequestHttpObject<T>(request, input.getRelayState(), signCred, destination, recipientMetadata, defaultSignatureSigningConfiguration);
            }
            throw new RequestGenerationException("Unsupported binding: " + binding);
        }
        catch (MessageEncodingException | SignatureException e) {
            String msg = "Failed to encode/sign request for transport";
            this.log.error(msg, e);
            throw new RequestGenerationException(msg);
        }
    }

    protected String generateID() {
        return "_" + new BigInteger(128, this.randomizer).toString(16);
    }

    protected X509Credential getSigningCredentials() {
        return this.signingCredentials;
    }

    protected Random getRandomizer() {
        return this.randomizer;
    }

    protected abstract String getDefaultBinding();

    @Override
    public String getEntityID() {
        return this.entityID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSigningCredentials(X509Credential signingCredentials) {
        this.signingCredentials = signingCredentials;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.name, (String)"Property 'name' must be assigned");
        if (this.signingCredentials == null) {
            this.log.warn("No signature credentials assigned - signing will not be possible");
        }
    }
}

