/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.request;

import java.util.function.Predicate;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.common.request.AbstractRequestGenerator;
import se.litsec.opensaml.saml2.common.request.AuthnRequestGenerator;
import se.litsec.opensaml.saml2.common.request.RequestGenerationException;
import se.litsec.opensaml.saml2.common.request.RequestGeneratorInput;

public abstract class AbstractAuthnRequestGenerator<I extends RequestGeneratorInput>
extends AbstractRequestGenerator<AuthnRequest, I>
implements AuthnRequestGenerator<I> {
    private final Logger log = LoggerFactory.getLogger(AbstractAuthnRequestGenerator.class);
    protected static Predicate<String> isValidBinding = b -> "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(b) || "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(b);
    protected static Predicate<SingleSignOnService> hasSupportedBinding = s -> isValidBinding.test(s.getBinding());

    public AbstractAuthnRequestGenerator(String entityID) {
        super(entityID);
    }

    protected SingleSignOnService getSingleSignOnService(EntityDescriptor idp, RequestGeneratorInput input) throws RequestGenerationException {
        String preferBinding = input.getPreferredBinding() != null ? input.getPreferredBinding() : this.getDefaultBinding();
        IDPSSODescriptor descriptor = idp.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (descriptor == null) {
            throw new RequestGenerationException("Invalid IdP metadata - missing IDPSSODescriptor");
        }
        SingleSignOnService ssoService = descriptor.getSingleSignOnServices().stream().filter(s -> preferBinding.equals(s.getBinding())).findFirst().orElse(null);
        if (ssoService == null) {
            ssoService = descriptor.getSingleSignOnServices().stream().filter(hasSupportedBinding).findFirst().orElse(null);
        }
        if (ssoService == null) {
            String msg = String.format("IdP '%s' does not specify endpoints for POST or Redirect - cannot send request", idp.getEntityID());
            this.log.error(msg);
            throw new RequestGenerationException(msg);
        }
        return ssoService;
    }
}

