/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.assertion;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.common.validation.AbstractObjectValidator;
import se.litsec.opensaml.common.validation.ValidationSupport;

public class AuthnStatementValidator
implements StatementValidator {
    public static final String AUTHN_REQUEST_FORCE_AUTHN = "saml2.AuthnRequestForceAuthn";
    public static final String AUTHN_REQUEST_ISSUE_INSTANT = "saml2.AuthnRequestIssueInstant";
    public static final String MAX_ACCEPTED_SSO_SESSION_TIME = "saml2.MaxAcceptedSsoSessionTime";
    private final Logger log = LoggerFactory.getLogger(AuthnStatementValidator.class);

    public QName getServicedStatement() {
        return AuthnStatement.DEFAULT_ELEMENT_NAME;
    }

    public final ValidationResult validate(Statement statement, Assertion assertion, ValidationContext context) throws AssertionValidationException {
        if (statement instanceof AuthnStatement) {
            return this.validate((AuthnStatement)statement, assertion, context);
        }
        throw new AssertionValidationException("Illegal call - statement is of type " + statement.getClass().getSimpleName());
    }

    protected ValidationResult validate(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        try {
            ValidationSupport.check(this.validateAuthnInstant(statement, assertion, context));
            ValidationSupport.check(this.validateSessionIndex(statement, assertion, context));
            ValidationSupport.check(this.validateSessionNotOnOrAfter(statement, assertion, context));
            ValidationSupport.check(this.validateSubjectLocality(statement, assertion, context));
            ValidationSupport.check(this.validateAuthnContext(statement, assertion, context));
        }
        catch (ValidationSupport.ValidationResultException e) {
            return e.getResult();
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAuthnInstant(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        if (statement.getAuthnInstant() == null) {
            context.setValidationFailureMessage("AuthnInstant of Assertion/@AuthnStatement is missing");
            return ValidationResult.INVALID;
        }
        if (statement.getAuthnInstant().isAfter((ReadableInstant)assertion.getIssueInstant())) {
            context.setValidationFailureMessage("AuthnInstant is after assertion issue instant - invalid");
            return ValidationResult.INVALID;
        }
        return this.validateSsoAndSession(statement.getAuthnInstant(), statement, assertion, context);
    }

    protected ValidationResult validateSsoAndSession(DateTime authnInstant, AuthnStatement statement, Assertion assertion, ValidationContext context) {
        Boolean forceAuthn = this.getForceAuthnFlag(context);
        Long authnRequestIssueInstant = this.getAuthnRequestIssueInstant(context);
        if (forceAuthn != null && forceAuthn.booleanValue()) {
            if (authnRequestIssueInstant != null) {
                if (authnInstant.getMillis() + AbstractObjectValidator.getAllowedClockSkew(context) < authnRequestIssueInstant) {
                    String msg = String.format("Invalid Assertion. Force authentication was requested, but authentication instant (%s) is before the issuance time of the authentication request (%s)", authnInstant, new DateTime((Object)authnRequestIssueInstant, (Chronology)ISOChronology.getInstanceUTC()));
                    context.setValidationFailureMessage(msg);
                    return ValidationResult.INVALID;
                }
            } else {
                this.log.warn("%s (or %s) not suppplied - cannot check SSO", (Object)AUTHN_REQUEST_ISSUE_INSTANT, (Object)"saml2.AuthnRequest");
            }
        } else {
            Long maxSessionTime = (Long)context.getStaticParameters().get(MAX_ACCEPTED_SSO_SESSION_TIME);
            if (maxSessionTime != null && authnInstant.getMillis() + maxSessionTime < AbstractObjectValidator.getReceiveInstant(context)) {
                String msg = String.format("Session length violation. Authentication instant (%s) is too far back in time to be accepted by SP SSO policy", authnInstant);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        }
        return ValidationResult.VALID;
    }

    protected Boolean getForceAuthnFlag(ValidationContext context) {
        AuthnRequest authnRequest;
        Boolean forceAuthn = (Boolean)context.getStaticParameters().get(AUTHN_REQUEST_FORCE_AUTHN);
        if (forceAuthn == null && (authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null) {
            forceAuthn = authnRequest.isForceAuthn();
        }
        return forceAuthn;
    }

    protected Long getAuthnRequestIssueInstant(ValidationContext context) {
        AuthnRequest authnRequest;
        Long issueInstant = (Long)context.getStaticParameters().get(AUTHN_REQUEST_ISSUE_INSTANT);
        if (issueInstant == null && (authnRequest = (AuthnRequest)context.getStaticParameters().get("saml2.AuthnRequest")) != null) {
            issueInstant = authnRequest.getIssueInstant().getMillis();
        }
        return issueInstant;
    }

    protected ValidationResult validateSessionIndex(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        return ValidationResult.VALID;
    }

    protected ValidationResult validateSessionNotOnOrAfter(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        return ValidationResult.VALID;
    }

    protected ValidationResult validateSubjectLocality(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAuthnContext(AuthnStatement statement, Assertion assertion, ValidationContext context) {
        if (statement.getAuthnContext() == null) {
            context.setValidationFailureMessage("AuthnContext element is missing in Assertion/@AuthnStatement");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }
}

