/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.common.assertion;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import se.litsec.opensaml.common.validation.AbstractSignableObjectValidator;
import se.litsec.opensaml.common.validation.ValidationSupport;

public class AssertionValidator
extends AbstractSignableObjectValidator<Assertion> {
    public static final String RESPONSE_ISSUE_INSTANT = "saml2.ResponseIssueInstant";
    private final Logger log = LoggerFactory.getLogger(AssertionValidator.class);
    protected Map<String, SubjectConfirmationValidator> subjectConfirmationValidators = new HashMap<String, SubjectConfirmationValidator>();
    protected Map<QName, ConditionValidator> conditionValidators;
    private Map<QName, StatementValidator> statementValidators;

    public AssertionValidator(SignatureTrustEngine trustEngine, SignaturePrevalidator signaturePrevalidator, Collection<SubjectConfirmationValidator> confirmationValidators, Collection<ConditionValidator> conditionValidators, Collection<StatementValidator> statementValidators) {
        super(trustEngine, signaturePrevalidator);
        if (confirmationValidators != null) {
            for (SubjectConfirmationValidator subjectConfirmationValidator : confirmationValidators) {
                if (subjectConfirmationValidator == null) continue;
                this.subjectConfirmationValidators.put(subjectConfirmationValidator.getServicedMethod(), subjectConfirmationValidator);
            }
        }
        this.conditionValidators = new HashMap<QName, ConditionValidator>();
        if (conditionValidators != null) {
            for (ConditionValidator conditionValidator : conditionValidators) {
                if (conditionValidator == null) continue;
                this.conditionValidators.put(conditionValidator.getServicedCondition(), conditionValidator);
            }
        }
        this.statementValidators = new HashMap<QName, StatementValidator>();
        if (statementValidators != null) {
            for (StatementValidator statementValidator : statementValidators) {
                if (statementValidator == null) continue;
                this.statementValidators.put(statementValidator.getServicedStatement(), statementValidator);
            }
        }
    }

    @Override
    public ValidationResult validate(Assertion assertion, ValidationContext context) {
        try {
            ValidationSupport.check(this.validateID(assertion, context));
            ValidationSupport.check(this.validateVersion(assertion, context));
            ValidationSupport.check(this.validateIssueInstant(assertion, context));
            ValidationSupport.check(this.validateIssuer(assertion, context));
            ValidationSupport.check(this.validateSignature(assertion, context));
            ValidationSupport.check(this.validateSubject(assertion, context));
            ValidationSupport.check(this.validateConditions(assertion, context));
            ValidationSupport.check(this.validateStatements(assertion, context));
        }
        catch (ValidationSupport.ValidationResultException e) {
            return e.getResult();
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateID(Assertion assertion, ValidationContext context) {
        if (!StringUtils.hasText((String)assertion.getID())) {
            context.setValidationFailureMessage("Missing ID attribute in Assertion");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateVersion(Assertion assertion, ValidationContext context) {
        if (assertion.getVersion() == null || !assertion.getVersion().toString().equals(SAMLVersion.VERSION_20.toString())) {
            context.setValidationFailureMessage("Invalid SAML version in Assertion");
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateIssueInstant(Assertion assertion, ValidationContext context) {
        if (assertion.getIssueInstant() == null) {
            context.setValidationFailureMessage("Missing IssueInstant attribute in Assertion");
            return ValidationResult.INVALID;
        }
        Long responseIssueInstant = (Long)context.getStaticParameters().get(RESPONSE_ISSUE_INSTANT);
        if (responseIssueInstant != null) {
            if (assertion.getIssueInstant().isAfter(responseIssueInstant.longValue())) {
                String msg = String.format("Invalid Assertion - Its issue-instant (%s) is after the response message issue-instant (%s)", assertion.getIssueInstant(), new DateTime((Object)responseIssueInstant, (Chronology)ISOChronology.getInstanceUTC()));
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        } else {
            long allowedClockSkew;
            long maxAgeResponse;
            long issueInstant;
            long receiveInstant = AssertionValidator.getReceiveInstant(context);
            if (receiveInstant - (issueInstant = assertion.getIssueInstant().getMillis()) > (maxAgeResponse = AssertionValidator.getMaxAgeReceivedMessage(context)) + (allowedClockSkew = AssertionValidator.getAllowedClockSkew(context))) {
                String msg = String.format("Received Assertion is too old - issue-instant: %s - receive-time: %s", assertion.getIssueInstant(), new DateTime(receiveInstant, (Chronology)ISOChronology.getInstanceUTC()));
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
            if (issueInstant - receiveInstant > allowedClockSkew) {
                String msg = String.format("Issue-instant of Assertion (%s) is newer than receive time (%s) - Non accepted clock skew", assertion.getIssueInstant(), new DateTime(receiveInstant, (Chronology)ISOChronology.getInstanceUTC()));
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateIssuer(Assertion assertion, ValidationContext context) {
        if (assertion.getIssuer() == null || assertion.getIssuer().getValue() == null) {
            context.setValidationFailureMessage("Missing Issuer element in Assertion");
            return ValidationResult.INVALID;
        }
        String expectedIssuer = (String)context.getStaticParameters().get("saml2.ExpectedIssuer");
        if (expectedIssuer != null) {
            if (!assertion.getIssuer().getValue().equals(expectedIssuer)) {
                String msg = String.format("Issuer of Assertion (%s) did not match expected issuer (%s)", assertion.getIssuer().getValue(), expectedIssuer);
                context.setValidationFailureMessage(msg);
                return ValidationResult.INVALID;
            }
        } else {
            this.log.warn("EXPECTED_ISSUER key not set - will not check issuer of Assertion");
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateSubject(Assertion assertion, ValidationContext context) {
        if (assertion.getSubject() == null) {
            if (assertion.getAuthnStatements() != null && !assertion.getAuthnStatements().isEmpty()) {
                context.setValidationFailureMessage("Assertion contains AuthnStatement but no Subject - invalid");
                return ValidationResult.INVALID;
            }
            this.log.debug("Assertion does not contain a Subject element - allowed by default assertion validator");
            return ValidationResult.VALID;
        }
        Subject subject = assertion.getSubject();
        List confirmations = subject.getSubjectConfirmations();
        if (confirmations == null || confirmations.isEmpty()) {
            this.log.debug("Assertion contains no SubjectConfirmations, default assertion validator skips subject confirmation");
            return ValidationResult.VALID;
        }
        return this.validateSubjectConfirmations(assertion, confirmations, context);
    }

    protected ValidationResult validateSubjectConfirmations(Assertion assertion, List<SubjectConfirmation> subjectConfirmations, ValidationContext context) {
        for (SubjectConfirmation confirmation : subjectConfirmations) {
            SubjectConfirmationValidator validator = this.subjectConfirmationValidators.get(confirmation.getMethod());
            if (validator == null) continue;
            try {
                ValidationResult r = validator.validate(confirmation, assertion, context);
                if (r == ValidationResult.VALID) {
                    context.getDynamicParameters().put("saml2.ConfirmedSubjectConfirmation", confirmation);
                    return ValidationResult.VALID;
                }
                this.log.info("Validation of SubjectConfirmation with method '{}' failed - {}", (Object)confirmation.getMethod(), (Object)context.getValidationFailureMessage());
            }
            catch (AssertionValidationException e) {
                this.log.warn("Error while executing subject confirmation validation " + validator.getClass().getName(), (Throwable)e);
            }
        }
        String msg = String.format("No subject confirmation methods were met for assertion with ID '%s'", assertion.getID());
        this.log.debug(msg);
        context.setValidationFailureMessage(msg);
        return ValidationResult.INVALID;
    }

    protected ValidationResult validateConditions(Assertion assertion, ValidationContext context) {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            this.log.debug("Assertion contained no Conditions element - allowed by default assertion validator");
            return ValidationResult.VALID;
        }
        ValidationResult timeboundsResult = this.validateConditionsTimeBounds(assertion, context);
        if (timeboundsResult != ValidationResult.VALID) {
            return timeboundsResult;
        }
        for (Condition condition : conditions.getConditions()) {
            ValidationResult r;
            ConditionValidator validator = this.conditionValidators.get(condition.getElementQName());
            if (validator == null && condition.getSchemaType() != null) {
                validator = this.conditionValidators.get(condition.getSchemaType());
            }
            if (validator == null) {
                String msg = String.format("Unknown Condition '%s' of type '%s' in assertion '%s'", condition.getElementQName(), condition.getSchemaType(), assertion.getID());
                this.log.warn(msg);
                if (!AssertionValidator.isStrictValidation(context)) continue;
                context.setValidationFailureMessage(msg);
                return ValidationResult.INDETERMINATE;
            }
            try {
                r = validator.validate(condition, assertion, context);
            }
            catch (AssertionValidationException e) {
                this.log.error("Failed Conditions validation - {}", (Object)e.getMessage());
                this.log.debug("", (Throwable)e);
                context.setValidationFailureMessage(e.getMessage());
                r = ValidationResult.INVALID;
            }
            if (r == ValidationResult.VALID) continue;
            String msg = String.format("Condition '%s' of type '%s' in assertion '%s' was not valid - %s.", condition.getElementQName(), condition.getSchemaType(), assertion.getID(), context.getValidationFailureMessage());
            if (context.getValidationFailureMessage() != null) {
                msg = msg + ": " + context.getValidationFailureMessage();
            }
            this.log.debug(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateConditionsTimeBounds(Assertion assertion, ValidationContext context) {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            return ValidationResult.VALID;
        }
        long clockSkew = AssertionValidator.getAllowedClockSkew(context);
        Long _receiveInstant = (Long)context.getStaticParameters().get("saml2.ReceiveInstant");
        DateTime receiveInstant = _receiveInstant != null ? new DateTime((Object)_receiveInstant, (Chronology)ISOChronology.getInstanceUTC()) : new DateTime((Chronology)ISOChronology.getInstanceUTC());
        DateTime notBefore = conditions.getNotBefore();
        this.log.debug("Evaluating Conditions NotBefore '{}' against 'skewed now' time '{}'", (Object)notBefore, (Object)receiveInstant.plus(clockSkew));
        if (notBefore != null && notBefore.isAfter((ReadableInstant)receiveInstant.plus(clockSkew))) {
            context.setValidationFailureMessage(String.format("Assertion '%s' with NotBefore condition of '%s' is not yet valid", assertion.getID(), notBefore));
            return ValidationResult.INVALID;
        }
        DateTime notOnOrAfter = conditions.getNotOnOrAfter();
        this.log.debug("Evaluating Conditions NotOnOrAfter '{}' against 'skewed now' time '{}'", (Object)notOnOrAfter, (Object)receiveInstant.minus(clockSkew));
        if (notOnOrAfter != null && notOnOrAfter.isBefore((ReadableInstant)receiveInstant.minus(clockSkew))) {
            context.setValidationFailureMessage(String.format("Assertion '%s' with NotOnOrAfter condition of '%s' is no longer valid", assertion.getID(), notOnOrAfter));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateStatements(Assertion assertion, ValidationContext context) {
        List statements = assertion.getStatements();
        if (statements == null || statements.isEmpty()) {
            return ValidationResult.VALID;
        }
        for (Statement statement : statements) {
            ValidationResult result;
            StatementValidator validator = this.statementValidators.get(statement.getElementQName());
            if (validator == null && statement.getSchemaType() != null) {
                validator = this.statementValidators.get(statement.getSchemaType());
            }
            if (validator == null) continue;
            try {
                result = validator.validate(statement, assertion, context);
            }
            catch (AssertionValidationException e) {
                this.log.error("Failed Statement validation - {}", (Object)e.getMessage());
                this.log.debug("", (Throwable)e);
                context.setValidationFailureMessage(e.getMessage());
                result = ValidationResult.INVALID;
            }
            if (result == ValidationResult.VALID) continue;
            return result;
        }
        return ValidationResult.VALID;
    }

    @Override
    protected String getIssuer(Assertion signableObject) {
        return signableObject.getIssuer() != null ? signableObject.getIssuer().getValue() : null;
    }

    @Override
    protected String getID(Assertion signableObject) {
        return signableObject.getID();
    }

    @Override
    protected String getObjectName() {
        return "Assertion";
    }
}

