/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.authentication.build;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.core.SAMLObjectBuilderRuntimeException;
import se.litsec.opensaml.saml2.attribute.AttributeUtils;
import se.litsec.opensaml.saml2.core.build.AbstractAuthnRequestBuilder;
import se.litsec.opensaml.saml2.core.build.NameIDPolicyBuilder;
import se.litsec.opensaml.saml2.core.build.RequestedAuthnContextBuilder;
import se.litsec.opensaml.saml2.metadata.MetadataUtils;
import se.litsec.opensaml.utils.ObjectUtils;

public class ExtendedAuthnRequestBuilder
extends AbstractAuthnRequestBuilder<ExtendedAuthnRequestBuilder> {
    public static final String DEFAULT_REQUEST_BINDING = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    public static final int DEFAULT_ID_SIZE = 24;
    private Logger log = LoggerFactory.getLogger(ExtendedAuthnRequestBuilder.class);
    final EntityDescriptor spMetadata;
    final EntityDescriptor idpMetadata;
    private String binding;

    public ExtendedAuthnRequestBuilder(EntityDescriptor spMetadata, EntityDescriptor idpMetadata) {
        if (spMetadata == null) {
            throw new IllegalArgumentException("spMetadata must not be null");
        }
        if (spMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") == null) {
            throw new IllegalArgumentException("spMetadata does not contain a SPSSODescriptor");
        }
        this.spMetadata = spMetadata;
        if (idpMetadata == null) {
            throw new IllegalArgumentException("idpMetadata must not be null");
        }
        if (idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") == null) {
            throw new IllegalArgumentException("idpMetadata does not contain a IDPSSODescriptor");
        }
        this.idpMetadata = idpMetadata;
    }

    public ExtendedAuthnRequestBuilder assignDefaults() {
        SPSSODescriptor spDescriptor = this.spMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        IDPSSODescriptor idpDescriptor = this.idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        this.version(SAMLVersion.VERSION_20.getMajorVersion(), SAMLVersion.VERSION_20.getMinorVersion());
        if (((AuthnRequest)this.object()).getID() == null) {
            this.log.debug("Generated an ID attribute and assigned it");
            this.id(24);
        }
        this.postProtocolBinding();
        if (((AuthnRequest)this.object()).getIssuer() == null) {
            this.log.debug("Assigning entityID '{}' to the Issuer element", (Object)this.spMetadata.getEntityID());
            this.issuer(this.spMetadata.getEntityID());
        }
        if (this.binding == null) {
            this.binding(DEFAULT_REQUEST_BINDING);
        }
        if (((AuthnRequest)this.object()).getAssertionConsumerServiceURL() == null) {
            Optional<String> serviceUrl = spDescriptor.getAssertionConsumerServices().stream().filter(a -> "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(a.getBinding())).filter(IndexedEndpoint::isDefault).map(Endpoint::getLocation).findFirst();
            if (!serviceUrl.isPresent()) {
                serviceUrl = spDescriptor.getAssertionConsumerServices().stream().filter(a -> "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(a.getBinding())).sorted((a1, a2) -> a1.getIndex() != null ? (a2.getIndex() != null ? a1.getIndex().compareTo(a2.getIndex()) : -1) : (a2.getIndex() != null ? 1 : 0)).map(Endpoint::getLocation).findFirst();
            }
            if (serviceUrl.isPresent()) {
                this.log.debug("Assigning URL '{}' to the AssertionConsumerServiceURL attribute", (Object)serviceUrl.get());
                ((AuthnRequest)this.object()).setAssertionConsumerServiceURL(serviceUrl.get());
            } else {
                this.log.info("The AssertionConsumerServiceURL attribute could not be assigned automatically. - Could not find a AssertionConsumerService element in the SP metadata that has the POST binding");
            }
        }
        if (((AuthnRequest)this.object()).getNameIDPolicy() == null) {
            Optional<String> nameIDFormat = spDescriptor.getNameIDFormats().stream().filter(n -> idpDescriptor.getNameIDFormats().stream().anyMatch(in -> in.getFormat().equals(n.getFormat()))).map(NameIDFormat::getFormat).findFirst();
            if (nameIDFormat.isPresent()) {
                this.log.debug("Assigning the '{}' Format to the NameIDPolicy element", (Object)nameIDFormat.get());
                this.nameIDPolicy((NameIDPolicy)NameIDPolicyBuilder.builder().allowCreate(true).format(nameIDFormat.get()).build());
            } else {
                this.log.info("Could not assign the NameIDPolicy element automatically - no matching formats between SP and IdP");
            }
        }
        return this;
    }

    public ExtendedAuthnRequestBuilder id(int idSize) {
        RandomIdentifierGenerationStrategy generator = new RandomIdentifierGenerationStrategy(idSize);
        super.id(generator.generateIdentifier());
        return this;
    }

    @Override
    public ExtendedAuthnRequestBuilder destination(String destination) {
        if (destination == null) {
            return (ExtendedAuthnRequestBuilder)super.destination(null);
        }
        Optional<SingleSignOnService> ssoService = this.idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleSignOnServices().stream().filter(s -> destination.equals(s.getLocation())).findFirst();
        if (!ssoService.isPresent()) {
            String msg = String.format("Metadata for IdP '%s' does not declare a SingleSignService element having its Location attribute set to '%s'", this.idpMetadata.getEntityID(), destination);
            this.log.error(msg);
            throw new SAMLObjectBuilderRuntimeException(msg);
        }
        this.log.debug("Assigning the Destination attribute to '{}' the setting the binding to '{}'", (Object)destination, (Object)ssoService.get().getBinding());
        this.binding = ssoService.get().getBinding();
        return (ExtendedAuthnRequestBuilder)super.destination(destination);
    }

    public String binding() {
        return this.binding;
    }

    public ExtendedAuthnRequestBuilder binding(String binding) throws SAMLObjectBuilderRuntimeException {
        if (binding == null) {
            throw new IllegalArgumentException("binding must not be null");
        }
        Optional<String> destination = this.idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleSignOnServices().stream().filter(s -> binding.equals(s.getBinding())).map(Endpoint::getLocation).findFirst();
        if (!destination.isPresent()) {
            String msg = String.format("Metadata for IdP '%s' does not declare a SingleSignOnService element having the '%s' binding", this.idpMetadata.getEntityID(), binding);
            this.log.error(msg);
            throw new SAMLObjectBuilderRuntimeException(msg);
        }
        this.log.debug("Assigning the '{}' binding and setting the Destination attribute to '{}'", (Object)binding, (Object)destination.get());
        this.binding = binding;
        super.destination(destination.get());
        return this;
    }

    public ExtendedAuthnRequestBuilder nameIDPolicyFormat(String format) throws SAMLObjectBuilderRuntimeException {
        if (format == null) {
            return (ExtendedAuthnRequestBuilder)this.nameIDPolicy(null);
        }
        boolean match = this.idpMetadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getNameIDFormats().stream().anyMatch(in -> in.getFormat().equals(format));
        if (!match) {
            String msg = String.format("IdP '%s' does not support NameID of format '%s'", this.idpMetadata.getEntityID(), format);
            this.log.error(msg);
            throw new SAMLObjectBuilderRuntimeException(msg);
        }
        this.nameIDPolicy((NameIDPolicy)NameIDPolicyBuilder.builder().allowCreate(true).format(format).build());
        return this;
    }

    public ExtendedAuthnRequestBuilder authnContextClassRefs(boolean onlyMatching, boolean failOnNoMatch, List<String> uris) throws SAMLObjectBuilderRuntimeException {
        List<String> urisToAdd;
        if (uris == null || uris.isEmpty()) {
            this.clearAuthnContextClassRefs();
            return this;
        }
        Optional<EntityAttributes> entityAttributes = MetadataUtils.getEntityAttributes(this.idpMetadata);
        Optional<List> assuranceCertificationAttribute = entityAttributes.flatMap(entityAttributes1 -> entityAttributes1.getAttributes().stream().filter(a -> "urn:oasis:names:tc:SAML:attribute:assurance-certification".equals(a.getName())).findFirst());
        List assuranceUris = assuranceCertificationAttribute.map(AttributeUtils::getAttributeStringValues).orElseGet(Collections::emptyList);
        List<String> list = onlyMatching ? uris.stream().filter(assuranceUris::contains).collect(Collectors.toList()) : (urisToAdd = uris);
        if (urisToAdd.isEmpty()) {
            String msg;
            String string = msg = assuranceUris.isEmpty() ? "IdP metadata does not specify any assuranceCertification URIs - failing to assign authentication context refs" : String.format("IdP metadata specified assurance URIs %s - call contained %s - no match", assuranceUris, uris);
            if (failOnNoMatch) {
                this.log.error(msg);
                throw new SAMLObjectBuilderRuntimeException(msg);
            }
            if (onlyMatching) {
                this.log.warn(msg);
                this.clearAuthnContextClassRefs();
                return this;
            }
        }
        if (((AuthnRequest)this.object()).getRequestedAuthnContext() == null) {
            this.requestedAuthnContext((RequestedAuthnContext)RequestedAuthnContextBuilder.builder().comparison(AuthnContextComparisonTypeEnumeration.EXACT).build());
        }
        ((AuthnRequest)this.object()).getRequestedAuthnContext().getAuthnContextClassRefs().clear();
        this.log.debug("Adding URI(s) %s as AuthnContextClassRef elements to RequestedAuthnContext", urisToAdd);
        for (String uri : urisToAdd) {
            AuthnContextClassRef accr = ObjectUtils.createSamlObject(AuthnContextClassRef.class);
            accr.setAuthnContextClassRef(uri);
            ((AuthnRequest)this.object()).getRequestedAuthnContext().getAuthnContextClassRefs().add(accr);
        }
        return this;
    }

    public ExtendedAuthnRequestBuilder authnContextClassRefs(boolean onlyMatching, boolean failOnNoMatch, String ... uris) throws SAMLObjectBuilderRuntimeException {
        return this.authnContextClassRefs(onlyMatching, failOnNoMatch, uris != null ? Arrays.asList(uris) : null);
    }

    private void clearAuthnContextClassRefs() {
        if (((AuthnRequest)this.object()).getRequestedAuthnContext() != null) {
            if (((AuthnRequest)this.object()).getRequestedAuthnContext().getAuthnContextDeclRefs().isEmpty()) {
                ((AuthnRequest)this.object()).setRequestedAuthnContext(null);
            } else {
                ((AuthnRequest)this.object()).getRequestedAuthnContext().getAuthnContextClassRefs().clear();
            }
        }
    }

    @Override
    protected ExtendedAuthnRequestBuilder getThis() {
        return this;
    }
}

