/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.attribute;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import se.litsec.opensaml.utils.ObjectUtils;

public class AttributeUtils {
    public static List<String> getAttributeStringValues(Attribute attribute) {
        return AttributeUtils.getAttributeValues(attribute, XSString.class).stream().map(XSString::getValue).collect(Collectors.toList());
    }

    public static String getAttributeStringValue(Attribute attribute) {
        XSString v = AttributeUtils.getAttributeValue(attribute, XSString.class);
        return v != null ? v.getValue() : null;
    }

    public static <T extends XMLObject> List<T> getAttributeValues(Attribute attribute, Class<T> type) {
        return attribute.getAttributeValues().stream().flatMap(o -> AttributeUtils.mapAttribute(o, type)).collect(Collectors.toList());
    }

    public static <T extends XMLObject> T getAttributeValue(Attribute attribute, Class<T> type) {
        return (T)((XMLObject)attribute.getAttributeValues().stream().flatMap(o -> AttributeUtils.mapAttribute(o, type)).findFirst().orElse(null));
    }

    public static Optional<Attribute> getAttribute(String name, List<Attribute> attributes) {
        if (attributes == null) {
            return Optional.empty();
        }
        return attributes.stream().filter(a -> a.getName().equals(name)).findFirst();
    }

    private static <T extends XMLObject, R extends XMLObject> Stream<T> mapAttribute(R obj, Class<T> type) {
        if (type.isInstance(obj)) {
            return Stream.of(type.cast(obj));
        }
        if (XSAny.class.isInstance(obj)) {
            if (type.isAssignableFrom(XSString.class)) {
                XSString newObject = ObjectUtils.createXMLObject(XSString.class, XSString.TYPE_NAME);
                newObject.setValue(((XSAny)obj).getTextContent());
                return Stream.of(type.cast(newObject));
            }
            if (type.isAssignableFrom(XSInteger.class)) {
                try {
                    Integer v = Integer.parseInt(((XSAny)obj).getTextContent());
                    XSInteger newObject = ObjectUtils.createXMLObject(XSInteger.class, XSInteger.TYPE_NAME);
                    newObject.setValue(v);
                    return Stream.of(type.cast(newObject));
                }
                catch (NumberFormatException e) {
                    return Stream.empty();
                }
            }
            if (type.isAssignableFrom(XSBoolean.class)) {
                Boolean b;
                String text = ((XSAny)obj).getTextContent();
                if (text == null) {
                    return Stream.empty();
                }
                Boolean bl = "true".equalsIgnoreCase(text) || "1".equals(text) ? Boolean.TRUE : (b = "false".equalsIgnoreCase(text) || "0".equals(text) ? Boolean.FALSE : null);
                if (b != null) {
                    XSBoolean newObject = ObjectUtils.createXMLObject(XSBoolean.class, XSBoolean.TYPE_NAME);
                    XSBooleanValue newValue = XSBooleanValue.valueOf((String)text);
                    newObject.setValue(newValue);
                    return Stream.of(type.cast(newObject));
                }
            } else if (type.isAssignableFrom(XSDateTime.class)) {
                String text = ((XSAny)obj).getTextContent();
                if (text == null) {
                    return Stream.empty();
                }
                try {
                    DateTime date = DateTime.parse((String)text, (DateTimeFormatter)ISODateTimeFormat.dateTime().withChronology((Chronology)ISOChronology.getInstanceUTC()));
                    if (date != null) {
                        XSDateTime newObject = ObjectUtils.createXMLObject(XSDateTime.class, XSDateTime.TYPE_NAME);
                        newObject.setValue(date);
                        return Stream.of(type.cast(newObject));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return Stream.empty();
    }

    private AttributeUtils() {
    }
}

