/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.core;

import java.util.Locale;

public class LocalizedString {
    public static final String DEFAULT_LANGUAGE_TAG = "en";
    private String localizedString;
    private String language;

    public LocalizedString(String source) {
        String _source = source.trim();
        int i = _source.indexOf(45);
        if (i <= 0 || i > 3) {
            throw new IllegalArgumentException("Bad format on localized string, expected <language code>-String");
        }
        this.localizedString = _source.substring(i + 1);
        this.language = _source.substring(0, i);
    }

    public LocalizedString(String localString, String language) {
        this.localizedString = localString;
        this.language = language;
    }

    public LocalizedString(String localString, Locale locale) {
        this.localizedString = localString;
        this.language = locale.getLanguage();
    }

    public String getLocalString() {
        return this.localizedString;
    }

    public void setLocalizedString(String newString) {
        this.localizedString = newString;
    }

    public String getLanguage() {
        return this.language != null ? this.language : DEFAULT_LANGUAGE_TAG;
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.language.hashCode();
        hash = hash * 31 + this.localizedString.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LocalizedString) {
            LocalizedString otherLString = (LocalizedString)obj;
            return this.localizedString.equals(otherLString.getLocalString()) && this.language.equals(otherLString.getLanguage());
        }
        return false;
    }

    public String toString() {
        return String.format("[%s] %s", this.getLanguage(), this.localizedString);
    }
}

