/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.common.validation;

import java.util.HashMap;
import java.util.Map;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.common.assertion.ValidationContext;
import se.litsec.opensaml.common.validation.ValidationParametersBuilder;

public abstract class AbstractValidationParametersBuilder<T extends AbstractValidationParametersBuilder<T>>
implements ValidationParametersBuilder {
    private Map<String, Object> staticParameters = new HashMap<String, Object>();
    private Map<String, Object> dynamicParameters = new HashMap<String, Object>();

    @Override
    public ValidationContext build() {
        ValidationContext context = new ValidationContext(this.staticParameters);
        context.getDynamicParameters().putAll(this.dynamicParameters);
        return context;
    }

    public T staticParameter(String name, Object value) {
        this.addStaticParameter(name, value);
        return this.getThis();
    }

    public T dynamicParameter(String name, Object value) {
        this.addStaticParameter(name, value);
        return this.getThis();
    }

    public T strictValidation(Boolean flag) {
        this.addStaticParameter("saml2.StrictValidation", flag);
        return this.getThis();
    }

    public T allowedClockSkew(Long millis) {
        this.addStaticParameter("saml2.ClockSkew", millis);
        return this.getThis();
    }

    public T maxAgeReceivedMessage(Long millis) {
        this.addStaticParameter("saml2.MaxAgeReceivedMessage", millis);
        return this.getThis();
    }

    public T signatureRequired(Boolean required) {
        this.addStaticParameter("saml2.SignatureRequired", required);
        return this.getThis();
    }

    public T signatureValidationCriteriaSet(CriteriaSet criteriaSet) {
        this.addStaticParameter("saml2.SignatureValidationCriteriaSet", criteriaSet);
        return this.getThis();
    }

    protected abstract T getThis();

    public final void addStaticParameter(String name, Object value) {
        this.staticParameters.put(name, value);
    }

    public final void addStaticParameters(Map<String, Object> pars) {
        this.staticParameters.putAll(pars);
    }

    public final void addDynamicParameter(String name, Object value) {
        this.staticParameters.put(name, value);
    }

    public final void addDynamicParameters(Map<String, Object> pars) {
        this.dynamicParameters.putAll(pars);
    }
}

