/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.common.validation;

import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import se.litsec.opensaml.common.validation.AbstractObjectValidator;

public abstract class AbstractSignableObjectValidator<T extends SignableXMLObject>
extends AbstractObjectValidator<T> {
    private final Logger log = LoggerFactory.getLogger(AbstractSignableObjectValidator.class);
    protected SignatureTrustEngine trustEngine;
    protected SignaturePrevalidator signaturePrevalidator;

    public AbstractSignableObjectValidator(SignatureTrustEngine trustEngine, SignaturePrevalidator signaturePrevalidator) {
        this.trustEngine = trustEngine;
        this.signaturePrevalidator = signaturePrevalidator;
    }

    protected ValidationResult validateSignature(T token, ValidationContext context) {
        Boolean signatureRequired = (Boolean)context.getStaticParameters().get("saml2.SignatureRequired");
        if (signatureRequired == null) {
            signatureRequired = Boolean.TRUE;
        }
        if (!token.isSigned()) {
            if (signatureRequired.booleanValue()) {
                context.setValidationFailureMessage(String.format("%s was required to be signed, but was not", this.getObjectName()));
                return ValidationResult.INVALID;
            }
            this.log.debug(String.format("%s was not required to be signed, and was not signed. Skipping further signature evaluation", this.getObjectName()));
            return ValidationResult.VALID;
        }
        if (this.trustEngine == null) {
            this.log.warn("Signature validation was necessary, but no signature trust engine was available");
            context.setValidationFailureMessage(String.format("%s signature could not be evaluated due to internal error", this.getObjectName()));
            return ValidationResult.INDETERMINATE;
        }
        return this.performSignatureValidation(token, context);
    }

    protected ValidationResult performSignatureValidation(T token, ValidationContext context) {
        Attr idAttr = token.getDOM().getAttributeNode("ID");
        if (idAttr != null) {
            idAttr.getOwnerElement().setIdAttributeNode(idAttr, true);
        }
        Signature signature = token.getSignature();
        String tokenIssuer = this.getIssuer(token);
        this.log.debug("Attempting signature validation on {} '{}' from Issuer '{}'", new Object[]{this.getObjectName(), this.getID(token), tokenIssuer});
        try {
            this.signaturePrevalidator.validate(signature);
        }
        catch (SignatureException e) {
            String msg = String.format("%s Signature failed pre-validation: %s", this.getObjectName(), e.getMessage());
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        CriteriaSet criteriaSet = this.getSignatureValidationCriteriaSet(token, context);
        try {
            if (this.trustEngine.validate((Object)signature, criteriaSet)) {
                this.log.debug("Validation of signature of {} '{}' from Issuer '{}' was successful", new Object[]{this.getObjectName(), this.getID(token), tokenIssuer});
                return ValidationResult.VALID;
            }
            String msg = String.format("Signature of %s '%s' from Issuer '%s' was not valid", this.getObjectName(), this.getID(token), tokenIssuer);
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
        catch (SecurityException e) {
            String msg = String.format("A problem was encountered evaluating the signature over %s with ID '%s': %s", this.getObjectName(), this.getID(token), e.getMessage());
            this.log.warn(msg);
            context.setValidationFailureMessage(msg);
            return ValidationResult.INVALID;
        }
    }

    protected CriteriaSet getSignatureValidationCriteriaSet(T token, ValidationContext context) {
        String issuer;
        CriteriaSet criteriaSet = (CriteriaSet)context.getStaticParameters().get("saml2.SignatureValidationCriteriaSet");
        if (criteriaSet == null) {
            criteriaSet = new CriteriaSet();
        }
        if (!criteriaSet.contains(EntityIdCriterion.class) && (issuer = this.getIssuer(token)) != null) {
            criteriaSet.add((Object)new EntityIdCriterion(issuer));
        }
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        return criteriaSet;
    }

    protected abstract String getIssuer(T var1);

    protected abstract String getID(T var1);

    protected abstract String getObjectName();
}

