/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.common.validation;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.assertion.ValidationContext;
import se.litsec.opensaml.common.validation.ObjectValidator;

public abstract class AbstractObjectValidator<T extends XMLObject>
implements ObjectValidator<T> {
    public static final long DEFAULT_ALLOWED_CLOCK_SKEW = 30000L;
    public static final long DEFAULT_MAX_AGE_RECEIVED_MESSAGE = 180000L;

    public static boolean isStrictValidation(ValidationContext context) {
        Boolean strict = (Boolean)context.getStaticParameters().get("saml2.StrictValidation");
        return strict != null ? strict : false;
    }

    public static long getAllowedClockSkew(ValidationContext context) {
        Long clockSkew = (Long)context.getStaticParameters().get("saml2.ClockSkew");
        return clockSkew != null ? clockSkew : 30000L;
    }

    public static long getMaxAgeReceivedMessage(ValidationContext context) {
        Long maxAge = (Long)context.getStaticParameters().get("saml2.MaxAgeReceivedMessage");
        return maxAge != null ? maxAge : 180000L;
    }

    public static long getReceiveInstant(ValidationContext context) {
        Long receiveInstant = (Long)context.getStaticParameters().get("saml2.ReceiveInstant");
        return receiveInstant != null ? receiveInstant : System.currentTimeMillis();
    }
}

