/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.standard;

import java.io.IOException;
import java.util.UUID;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.format.ValueType;

public class UuidSerializer
implements Serializer<UUID> {
    private final SerializerFormatDefinition formatDefinition = SerializerFormatDefinition.forValue(ValueType.BYTES);

    @Override
    public UUID read(StreamingInput in) throws IOException {
        in.next(Token.VALUE);
        return UuidSerializer.fromBytes0(in.getByteArray());
    }

    @Override
    public void write(UUID object, String name, StreamingOutput stream) throws IOException {
        stream.write(name, UuidSerializer.toBytes0(object));
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }

    private static UUID fromBytes0(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        long msb = 0L;
        long lsb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(bytes[i] & 0xFF);
            lsb = lsb << 8 | (long)(bytes[8 + i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    private static byte[] toBytes0(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (int i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
            buffer[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }
}

