/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal.reflection;

import java.util.Map;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.internal.reflection.FactoryDefinition;
import se.l4.commons.serialization.internal.reflection.FieldDefinition;

public class TypeInfo<T> {
    private final FieldDefinition[] fields;
    private final Class<T> type;
    private final Map<String, FieldDefinition> fieldMap;
    private final FactoryDefinition<T>[] factories;
    private final SerializerFormatDefinition formatDefinition;

    public TypeInfo(Class<T> type, FactoryDefinition<T>[] factories, Map<String, FieldDefinition> fieldMap, FieldDefinition[] fields) {
        this.type = type;
        this.factories = factories;
        this.fieldMap = fieldMap;
        this.fields = fields;
        SerializerFormatDefinition.Builder builder = SerializerFormatDefinition.builder();
        for (FieldDefinition fdef : fields) {
            builder.field(fdef.getName()).withType(fdef.getType()).withHints(fdef.getHints()).using(fdef.getSerializer());
        }
        this.formatDefinition = builder.build();
    }

    public Class<T> getType() {
        return this.type;
    }

    public FieldDefinition[] getAllFields() {
        return this.fields;
    }

    public FieldDefinition getField(String name) {
        return this.fieldMap.get(name);
    }

    public T newInstance(Map<String, Object> fields) {
        try {
            FactoryDefinition<T> bestDef = this.factories[0];
            int bestScore = bestDef.getScore(fields);
            int n = this.factories.length;
            for (int i = 1; i < n; ++i) {
                int score = this.factories[i].getScore(fields);
                if (score <= bestScore) continue;
                bestDef = this.factories[i];
                bestScore = score;
            }
            return bestDef.create(fields);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not create " + this.type + "; " + e.getMessage(), e);
        }
    }

    public SerializerFormatDefinition getFormatDefinition() {
        return this.formatDefinition;
    }
}

