/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.ValueType;
import se.l4.commons.serialization.spi.Type;
import se.l4.commons.serialization.spi.TypeViaClass;

public class SerializerFormatDefinitionBuilderImpl
implements SerializerFormatDefinition.Builder {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final List<SerializerFormatDefinition.FieldDefinition> fields = new ArrayList<SerializerFormatDefinition.FieldDefinition>();
    private int type = 1;
    private ValueType valueType;
    private SerializerFormatDefinition itemDefinition;

    @Override
    public SerializerFormatDefinition.FieldBuilder field(String name) {
        return new FieldBuilderImpl(name);
    }

    @Override
    public SerializerFormatDefinition.Builder list(SerializerFormatDefinition itemDefinition) {
        this.type = 2;
        this.itemDefinition = itemDefinition;
        return this;
    }

    @Override
    public SerializerFormatDefinition.Builder list(Serializer<?> itemSerializer) {
        return this.list(itemSerializer.getFormatDefinition());
    }

    @Override
    public SerializerFormatDefinition.Builder object() {
        this.type = 1;
        return this;
    }

    @Override
    public SerializerFormatDefinition.Builder value(ValueType valueType) {
        this.type = 0;
        this.valueType = valueType;
        return this;
    }

    @Override
    public SerializerFormatDefinition build() {
        if (this.type == 0) {
            return SerializerFormatDefinition.forValue(this.valueType);
        }
        return new SerializerFormatDefinition(this.type, this.valueType, this.fields);
    }

    private class FieldBuilderImpl
    implements SerializerFormatDefinition.FieldBuilder {
        private final Collection<Annotation> hints;
        private String name;
        private Type type;

        public FieldBuilderImpl(String name) {
            this.name = name;
            this.hints = new LinkedHashSet<Annotation>();
        }

        @Override
        public SerializerFormatDefinition.FieldBuilder withHint(Annotation hint) {
            this.hints.add(hint);
            return this;
        }

        @Override
        public SerializerFormatDefinition.FieldBuilder withHints(Annotation ... hints) {
            for (Annotation a : hints) {
                this.hints.add(a);
            }
            return this;
        }

        @Override
        public SerializerFormatDefinition.FieldBuilder withType(Class<?> type) {
            return this.withType(new TypeViaClass(type));
        }

        @Override
        public SerializerFormatDefinition.FieldBuilder withType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public SerializerFormatDefinition.Builder using(Serializer<?> serializer) {
            return this.using(serializer.getFormatDefinition());
        }

        @Override
        public SerializerFormatDefinition.Builder using(ValueType valueType) {
            return this.using(SerializerFormatDefinition.forValue(valueType));
        }

        @Override
        public SerializerFormatDefinition.Builder using(SerializerFormatDefinition def) {
            SerializerFormatDefinitionBuilderImpl.this.fields.add(new SerializerFormatDefinition.FieldDefinition(this.name, def, this.type, this.hints.isEmpty() ? EMPTY_ANNOTATIONS : this.hints.toArray(EMPTY_ANNOTATIONS)));
            return SerializerFormatDefinitionBuilderImpl.this;
        }
    }
}

