/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.spi.Type;

public class DelayedSerializer<T>
implements Serializer<T> {
    private final SerializerCollection collection;
    private final Type type;
    private final Annotation[] hints;
    private volatile Serializer<T> instance;

    public DelayedSerializer(SerializerCollection collection, Type type, Annotation[] hints) {
        this.collection = collection;
        this.type = type;
        this.hints = hints;
    }

    private void ensureSerializer() {
        if (this.instance == null) {
            this.instance = this.collection.find(this.type, this.hints);
            if (this.instance instanceof DelayedSerializer) {
                this.instance = null;
            }
        }
    }

    @Override
    public T read(StreamingInput in) throws IOException {
        this.ensureSerializer();
        return this.instance.read(in);
    }

    @Override
    public void write(T object, String name, StreamingOutput stream) throws IOException {
        this.ensureSerializer();
        this.instance.write(object, name, stream);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        this.ensureSerializer();
        if (this.instance == null) {
            return null;
        }
        return this.instance.getFormatDefinition();
    }
}

