/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.format;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import se.l4.commons.serialization.format.AbstractStreamingInput;
import se.l4.commons.serialization.format.Token;

public class BinaryInput
extends AbstractStreamingInput {
    private static final int CHARS_SIZE = 1024;
    private static final ThreadLocal<char[]> CHARS = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };
    private final InputStream in;
    private final byte[] buffer;
    private int peekedByte;

    public BinaryInput(InputStream in) {
        this.in = in;
        this.buffer = new byte[8];
        this.peekedByte = -2;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public Token peek() throws IOException {
        if (this.peekedByte == -2) {
            this.peekedByte = this.in.read();
        }
        switch (this.peekedByte) {
            case -1: {
                return null;
            }
            case 0: {
                return Token.KEY;
            }
            case 1: {
                return Token.OBJECT_START;
            }
            case 2: {
                return Token.OBJECT_END;
            }
            case 3: {
                return Token.LIST_START;
            }
            case 4: {
                return Token.LIST_END;
            }
            case 13: {
                return Token.NULL;
            }
        }
        return Token.VALUE;
    }

    @Override
    protected Token next0() throws IOException {
        Token current = this.peek();
        if (current == Token.KEY || current == Token.VALUE || current == Token.NULL) {
            this.readValue();
        }
        this.peekedByte = this.in.read();
        return current;
    }

    private void readBuffer(int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.in.read(this.buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException("Expected to read " + len + " bytes, but could only read " + n);
        }
    }

    private double readDouble() throws IOException {
        this.readBuffer(8);
        long value = (long)this.buffer[0] & 0xFFL | ((long)this.buffer[1] & 0xFFL) << 8 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[7] & 0xFFL) << 56;
        return Double.longBitsToDouble(value);
    }

    private float readFloat() throws IOException {
        this.readBuffer(4);
        int value = this.buffer[0] & 0xFF | (this.buffer[1] & 0xFF) << 8 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[3] & 0xFF) << 24;
        return Float.intBitsToFloat(value);
    }

    private int readInteger() throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            byte b = (byte)this.in.read();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new EOFException("Invalid integer");
    }

    private long readLong() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = (byte)this.in.read();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new EOFException("Invalid long");
    }

    private String readString() throws IOException {
        int length = this.readInteger();
        char[] chars = length < 1024 ? CHARS.get() : new char[length];
        for (int i = 0; i < length; ++i) {
            int c = this.in.read() & 0xFF;
            int t = c >> 4;
            if (t > -1 && t < 8) {
                chars[i] = (char)c;
                continue;
            }
            if (t == 12 || t == 13) {
                chars[i] = (char)((c & 0x1F) << 6 | this.in.read() & 0x3F);
                continue;
            }
            if (t != 14) continue;
            chars[i] = (char)((c & 0xF) << 12 | (this.in.read() & 0x3F) << 6 | (this.in.read() & 0x3F) << 0);
        }
        return new String(chars, 0, length);
    }

    private byte[] readByteArray() throws IOException {
        int length = this.readInteger();
        byte[] buffer = new byte[length];
        int read = this.in.read(buffer);
        if (read != length) {
            throw new EOFException("Stream ended before entire byte array was sent");
        }
        return buffer;
    }

    private void readValue() throws IOException {
        switch (this.peekedByte) {
            case 16: {
                int b = this.in.read();
                this.setValue(b == 1);
                break;
            }
            case 15: {
                this.setValue(this.readDouble());
                break;
            }
            case 14: {
                this.setValue(Float.valueOf(this.readFloat()));
                break;
            }
            case 11: {
                int i = this.readInteger();
                i = i >>> 1 ^ -(i & 1);
                this.setValue(i);
                break;
            }
            case 18: {
                this.setValue(this.readInteger());
                break;
            }
            case 20: {
                this.setValue(-this.readInteger());
                break;
            }
            case 12: {
                long l = this.readLong();
                l = l >>> 1 ^ -(l & 1L);
                this.setValue(l);
                break;
            }
            case 19: {
                this.setValue(this.readLong());
                break;
            }
            case 21: {
                this.setValue(-this.readLong());
                break;
            }
            case 13: {
                this.setValue(null);
                break;
            }
            case 0: 
            case 10: {
                this.setValue(this.readString());
                break;
            }
            case 17: {
                this.setValue(this.readByteArray());
                break;
            }
            default: {
                throw new IOException("Unexpected value type, no idea what to do (type was " + this.peekedByte + ")");
            }
        }
    }
}

