/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedConstructor;
import com.fasterxml.classmate.members.ResolvedField;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import se.l4.commons.serialization.AllowAny;
import se.l4.commons.serialization.AllowSimpleTypes;
import se.l4.commons.serialization.Expose;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerCollection;
import se.l4.commons.serialization.SkipDefaultValue;
import se.l4.commons.serialization.Use;
import se.l4.commons.serialization.internal.TypeViaResolvedType;
import se.l4.commons.serialization.internal.reflection.FactoryDefinition;
import se.l4.commons.serialization.internal.reflection.FieldDefinition;
import se.l4.commons.serialization.internal.reflection.ReflectionNonStreamingSerializer;
import se.l4.commons.serialization.internal.reflection.ReflectionStreamingSerializer;
import se.l4.commons.serialization.internal.reflection.TypeInfo;
import se.l4.commons.serialization.spi.AbstractSerializerResolver;
import se.l4.commons.serialization.spi.SerializerResolver;
import se.l4.commons.serialization.spi.Type;
import se.l4.commons.serialization.spi.TypeEncounter;
import se.l4.commons.serialization.standard.CompactDynamicSerializer;
import se.l4.commons.serialization.standard.DynamicSerializer;
import se.l4.commons.serialization.standard.SimpleTypeSerializer;

public class ReflectionSerializer<T>
extends AbstractSerializerResolver<T> {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Serializer<T> find(TypeEncounter encounter) {
        Object def;
        Type type = encounter.getType();
        SerializerCollection collection = encounter.getCollection();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder nonRenamedFields = ImmutableMap.builder();
        TypeResolver typeResolver = new TypeResolver();
        MemberResolver memberResolver = new MemberResolver(typeResolver);
        Type[] params = type.getParameters();
        ResolvedType rt = params.length == 0 ? typeResolver.resolve(type.getErasedType(), new java.lang.reflect.Type[0]) : ReflectionSerializer.resolveWithParams(typeResolver, type);
        ResolvedTypeWithMembers typeWithMembers = memberResolver.resolve(rt, null, null);
        for (ResolvedField field : typeWithMembers.getMemberFields()) {
            void var17_20;
            Field reflectiveField = (Field)field.getRawMember();
            if (!reflectiveField.isAnnotationPresent(Expose.class)) continue;
            ResolvedConstructor[] fieldType = field.getType();
            if (reflectiveField.isAnnotationPresent(Use.class)) {
                Use annotation = reflectiveField.getAnnotation(Use.class);
                if (Serializer.class.isAssignableFrom(annotation.value())) {
                    try {
                        Serializer serializer = (Serializer)collection.getInstanceFactory().create(annotation.value());
                    }
                    catch (Exception e) {
                        throw new SerializationException("Unable to create " + annotation.value() + " for " + type + "; " + e.getMessage(), e);
                    }
                } else {
                    if (!SerializerResolver.class.isAssignableFrom(annotation.value())) throw new SerializationException("Unable to create " + annotation.value() + " for " + type + "; Class either needs to a Serializer or a SerializerResolver");
                    Serializer serializer = collection.findVia(annotation.value(), new TypeViaResolvedType((ResolvedType)fieldType), reflectiveField.getAnnotations());
                }
            } else if (reflectiveField.isAnnotationPresent(AllowAny.class)) {
                AllowAny allowAny = reflectiveField.getAnnotation(AllowAny.class);
                Serializer<Object> serializer = allowAny.compact() ? new CompactDynamicSerializer(collection) : new DynamicSerializer(collection);
            } else if (reflectiveField.isAnnotationPresent(AllowSimpleTypes.class)) {
                SimpleTypeSerializer simpleTypeSerializer = new SimpleTypeSerializer();
            } else {
                try {
                    Serializer<?> serializer = collection.find(new TypeViaResolvedType((ResolvedType)fieldType), reflectiveField.getAnnotations());
                }
                catch (SerializationException e) {
                    throw new SerializationException("Could not resolve " + field.getName() + " for " + type.getErasedType() + "; " + e.getMessage(), e);
                }
            }
            if (var17_20 == null) {
                throw new SerializationException("Could not resolve " + field.getName() + " for " + type.getErasedType() + "; No serializer found");
            }
            boolean skipIfDefault = reflectiveField.isAnnotationPresent(SkipDefaultValue.class);
            reflectiveField.setAccessible(true);
            String name = ReflectionSerializer.getName(reflectiveField);
            def = new FieldDefinition(reflectiveField, name, (Serializer)var17_20, fieldType.getErasedType(), skipIfDefault);
            builder.put((Object)name, def);
            nonRenamedFields.put((Object)reflectiveField.getName(), def);
        }
        ImmutableMap fields = builder.build();
        ImmutableMap nonRenamed = builder.build();
        FieldDefinition[] fieldsCache = (FieldDefinition[])fields.values().toArray((Object[])new FieldDefinition[0]);
        boolean hasSerializerInFactory = false;
        ArrayList factories = Lists.newArrayList();
        for (ResolvedConstructor constructor : typeWithMembers.getConstructors()) {
            def = new FactoryDefinition(collection, (Map<String, FieldDefinition>)fields, (Map<String, FieldDefinition>)nonRenamed, constructor);
            hasSerializerInFactory |= ((FactoryDefinition)def).hasSerializedFields();
            if (!((FactoryDefinition)def).hasSerializedFields() && !((FactoryDefinition)def).isInjectable()) continue;
            factories.add(def);
        }
        if (factories.isEmpty()) {
            throw new SerializationException("Unable to create any instance of " + type + ", at least a default constructor is needed");
        }
        FactoryDefinition[] factoryCache = factories.toArray(new FactoryDefinition[factories.size()]);
        TypeInfo typeInfo = new TypeInfo(type.getErasedType(), factoryCache, (Map<String, FieldDefinition>)fields, fieldsCache);
        return hasSerializerInFactory ? new ReflectionNonStreamingSerializer(typeInfo) : new ReflectionStreamingSerializer(typeInfo);
    }

    private static ResolvedType resolveWithParams(TypeResolver typeResolver, Type type) {
        if (type instanceof TypeViaResolvedType) {
            return ((TypeViaResolvedType)type).getResolvedType();
        }
        return null;
    }

    private static String getName(Field field) {
        Expose annotation;
        if (field.isAnnotationPresent(Expose.class) && !"".equals((annotation = field.getAnnotation(Expose.class)).value())) {
            return annotation.value();
        }
        return field.getName();
    }
}

