/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import se.l4.commons.io.ByteArrayConsumer;
import se.l4.commons.io.Bytes;
import se.l4.commons.io.ChunkOutputStream;
import se.l4.commons.io.ExtendedDataOutput;
import se.l4.commons.io.ExtendedDataOutputStream;
import se.l4.commons.io.IoConsumer;

public class BytesBuilder {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream(8192);

    public BytesBuilder addChunk(byte[] buffer) {
        return this.addChunk(buffer, 0, buffer.length);
    }

    public BytesBuilder addChunk(byte[] buffer, int off, int len) {
        this.out.write(buffer, off, len);
        return this;
    }

    public Bytes build() {
        return Bytes.create(this.out.toByteArray());
    }

    static Bytes createViaLazyDataOutput(IoConsumer<ExtendedDataOutput> creator) {
        return BytesBuilder.createViaLazyDataOutput(creator, 8192);
    }

    static Bytes createViaLazyDataOutput(IoConsumer<ExtendedDataOutput> creator, int expectedSize) {
        return new DataOutputBytes(creator, expectedSize);
    }

    static Bytes createViaDataOutput(IoConsumer<ExtendedDataOutput> creator) throws IOException {
        return BytesBuilder.createViaDataOutput(creator, 8192);
    }

    static Bytes createViaDataOutput(IoConsumer<ExtendedDataOutput> creator, int expectedSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(expectedSize);
        try (ExtendedDataOutputStream dataOut = new ExtendedDataOutputStream(out);){
            creator.accept(dataOut);
        }
        return Bytes.create(out.toByteArray());
    }

    private static class DataOutputBytes
    implements Bytes {
        private final IoConsumer<ExtendedDataOutput> creator;
        private final int expectedSize;

        public DataOutputBytes(IoConsumer<ExtendedDataOutput> creator, int expectedSize) {
            this.creator = creator;
            this.expectedSize = expectedSize;
        }

        @Override
        public InputStream asInputStream() throws IOException {
            return new ByteArrayInputStream(this.toByteArray());
        }

        @Override
        public byte[] toByteArray() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.expectedSize);
            try (ExtendedDataOutputStream dataOut = new ExtendedDataOutputStream(out);){
                this.creator.accept(dataOut);
            }
            return out.toByteArray();
        }

        @Override
        public void asChunks(ByteArrayConsumer consumer) throws IOException {
            try (ExtendedDataOutputStream dataOut = new ExtendedDataOutputStream(new ChunkOutputStream(4096, consumer));){
                this.creator.accept(dataOut);
            }
        }
    }
}

