/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal.streaming;

import java.io.IOException;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public class ValueInput
implements StreamingInput {
    private final Object value;
    private boolean used;
    private String key;

    public ValueInput(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Token peek() throws IOException {
        return this.used ? null : Token.VALUE;
    }

    @Override
    public Token next() throws IOException {
        if (this.used) {
            return null;
        }
        this.used = true;
        return Token.VALUE;
    }

    @Override
    public Token next(Token expected) throws IOException {
        Token token = this.next();
        if (expected != Token.VALUE) {
            throw new IOException(this.key + ": Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)token));
        }
        return token;
    }

    @Override
    public void skip() throws IOException {
    }

    @Override
    public void skipValue() throws IOException {
    }

    @Override
    public Token current() {
        return Token.VALUE;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean getBoolean() {
        return this.value instanceof Boolean ? (Boolean)this.value : Boolean.parseBoolean(this.getString());
    }

    @Override
    public double getDouble() {
        return ((Number)this.value).doubleValue();
    }

    @Override
    public float getFloat() {
        return ((Number)this.value).floatValue();
    }

    @Override
    public long getLong() {
        return ((Number)this.value).longValue();
    }

    @Override
    public int getInt() {
        return ((Number)this.value).intValue();
    }

    @Override
    public short getShort() {
        return ((Number)this.value).shortValue();
    }

    @Override
    public byte[] getByteArray() {
        return (byte[])this.value;
    }
}

