/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.l4.commons.config.internal.streaming.ConfigJsonInput;
import se.l4.commons.serialization.SerializationException;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public class RawFormatReader {
    private RawFormatReader() {
    }

    public static Map<String, Object> read(InputStream stream) throws IOException {
        ConfigJsonInput input = new ConfigJsonInput(new InputStreamReader(stream));
        return RawFormatReader.read(input);
    }

    public static Map<String, Object> read(StreamingInput input) throws IOException {
        Token next = input.peek();
        if (next == null) {
            return Collections.emptyMap();
        }
        switch (next) {
            case LIST_START: 
            case LIST_END: 
            case OBJECT_END: 
            case VALUE: 
            case NULL: {
                throw new SerializationException("Error in configuration file, should be in in key, value format");
            }
        }
        return RawFormatReader.readMap(input);
    }

    private static Map<String, Object> readMap(StreamingInput input) throws IOException {
        Token t;
        boolean readEnd = false;
        if (input.peek() == Token.OBJECT_START) {
            readEnd = true;
            input.next();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        while ((t = input.peek()) != Token.OBJECT_END && t != null) {
            input.next(Token.KEY);
            String key = input.getString();
            Object value = RawFormatReader.readDynamic(input);
            result.put(key, value);
        }
        if (readEnd) {
            input.next(Token.OBJECT_END);
        }
        return result;
    }

    private static List<Object> readList(StreamingInput input) throws IOException {
        input.next(Token.LIST_START);
        ArrayList<Object> result = new ArrayList<Object>();
        while (input.peek() != Token.LIST_END) {
            Object value = RawFormatReader.readDynamic(input);
            result.add(value);
        }
        input.next(Token.LIST_END);
        return result;
    }

    private static Object readDynamic(StreamingInput input) throws IOException {
        switch (input.peek()) {
            case VALUE: {
                input.next();
                return input.getValue();
            }
            case NULL: {
                input.next();
                return input.getValue();
            }
            case LIST_START: {
                return RawFormatReader.readList(input);
            }
            case OBJECT_START: {
                return RawFormatReader.readMap(input);
            }
        }
        throw new SerializationException("Unable to read file, unknown start of value: " + (Object)((Object)input.peek()));
    }
}

