/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config.internal.streaming;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.bind.DatatypeConverter;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public class ConfigJsonInput
implements StreamingInput {
    private static final char NULL = '\u0000';
    private final Reader in;
    private final char[] buffer;
    private int position;
    private int limit;
    private final boolean[] lists;
    private int level;
    private Token token;
    private Object value;

    public ConfigJsonInput(Reader in) {
        this.in = in;
        this.lists = new boolean[20];
        this.buffer = new char[1024];
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private void readWhitespace() throws IOException {
        while (true) {
            if (this.limit - this.position < 1 && !this.read(1)) {
                return;
            }
            char c = this.buffer[this.position];
            if (Character.isWhitespace(c) || c == ',') {
                ++this.position;
                continue;
            }
            if (c != '#') break;
            this.readUntilEndOfLine();
        }
    }

    private void readUntilEndOfLine() throws IOException {
        while (this.limit - this.position >= 1 || this.read(1)) {
            char c = this.buffer[this.position];
            if (c == '\n' || c == '\r') {
                return;
            }
            ++this.position;
        }
        return;
    }

    private char readNext() throws IOException {
        this.readWhitespace();
        return this.read();
    }

    private char read() throws IOException {
        if (this.limit - this.position < 1 && !this.read(1)) {
            throw new EOFException();
        }
        return this.buffer[this.position++];
    }

    private boolean read(int minChars) throws IOException {
        if (this.limit < 0) {
            return false;
        }
        if (this.position + minChars < this.limit) {
            return true;
        }
        if (this.limit >= this.position) {
            int stop = this.limit - this.position;
            System.arraycopy(this.buffer, this.position, this.buffer, 0, stop);
            this.limit = stop;
        }
        int read = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit);
        this.position = 0;
        this.limit = read;
        if (read == -1) {
            return false;
        }
        if (read < minChars) {
            throw new IOException("Needed " + minChars + " but got " + read);
        }
        return true;
    }

    private Token toToken(int position) throws IOException {
        if (position > this.limit) {
            return null;
        }
        char c = this.buffer[position];
        switch (c) {
            case '{': {
                return Token.OBJECT_START;
            }
            case '}': {
                return Token.OBJECT_END;
            }
            case '[': {
                return Token.LIST_START;
            }
            case ']': {
                return Token.LIST_END;
            }
        }
        if (this.token != Token.KEY && !this.lists[this.level]) {
            return Token.KEY;
        }
        if (c == 'n') {
            return this.checkString("null", false) ? Token.NULL : Token.VALUE;
        }
        return Token.VALUE;
    }

    private Object readNextValue() throws IOException {
        char c = this.readNext();
        if (c == '\"') {
            return this.readString(false);
        }
        StringBuilder value = new StringBuilder();
        block3: while (true) {
            value.append(c);
            c = this.peekChar(false);
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case ',': 
                case ':': 
                case '=': 
                case ']': 
                case '}': {
                    break block3;
                }
                default: {
                    this.read();
                    continue block3;
                }
            }
            break;
        }
        return this.toObject(value.toString().trim());
    }

    private Object toObject(String in) {
        if (in.equals("false")) {
            return false;
        }
        if (in.equals("true")) {
            return true;
        }
        try {
            return Long.parseLong(in);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(in);
            }
            catch (NumberFormatException numberFormatException) {
                return in;
            }
        }
    }

    private String readString(boolean readStart) throws IOException {
        StringBuilder key = new StringBuilder();
        char c = this.read();
        if (readStart) {
            if (c != '\"') {
                throw new IOException("Expected \", but got " + c);
            }
            c = this.read();
        }
        while (c != '\"') {
            if (c == '\\') {
                this.readEscaped(key);
            } else {
                key.append(c);
            }
            c = this.read();
        }
        return key.toString();
    }

    private String readKey() throws IOException {
        StringBuilder key = new StringBuilder();
        char c = this.read();
        while (c != ':' && c != '=') {
            if (c == '\\') {
                this.readEscaped(key);
            } else if (!Character.isWhitespace(c)) {
                key.append(c);
            }
            c = this.peekChar();
            if (c == '{' || c == '[') break;
            c = this.read();
        }
        return key.toString();
    }

    private void readEscaped(StringBuilder result) throws IOException {
        char c = this.read();
        switch (c) {
            case '\'': {
                result.append('\'');
                break;
            }
            case '\"': {
                result.append('\"');
                break;
            }
            case '\\': {
                result.append('\\');
                break;
            }
            case '/': {
                result.append('/');
                break;
            }
            case 'r': {
                result.append('\r');
                break;
            }
            case 'n': {
                result.append('\n');
                break;
            }
            case 't': {
                result.append('\t');
                break;
            }
            case 'b': {
                result.append('\b');
                break;
            }
            case 'f': {
                result.append('\f');
                break;
            }
            case 'u': {
                this.read(4);
                String s = new String(this.buffer, this.position, 4);
                result.append((char)Integer.parseInt(s, 16));
                this.position += 4;
            }
        }
    }

    @Override
    public Token next(Token expected) throws IOException {
        Token t = this.next();
        if (t != expected) {
            throw new IOException("Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)t));
        }
        return t;
    }

    @Override
    public Token next() throws IOException {
        char peeked = this.peekChar();
        Token token = this.toToken(this.position);
        switch (token) {
            case OBJECT_END: 
            case LIST_END: {
                this.readNext();
                --this.level;
                this.token = token;
                return this.token;
            }
            case OBJECT_START: 
            case LIST_START: {
                this.readNext();
                ++this.level;
                this.lists[this.level] = token == Token.LIST_START;
                this.token = token;
                return this.token;
            }
            case KEY: {
                String key;
                this.readWhitespace();
                if (peeked == '\"') {
                    key = this.readString(true);
                    key = "\"" + key + "\"";
                    char next = this.peekChar();
                    if (next == ':' || next == '=') {
                        this.readNext();
                    } else if (next != '{' && next != '[') {
                        throw new IOException("Expected :, got " + next);
                    }
                } else {
                    key = this.readKey();
                }
                this.value = key;
                this.token = token;
                return this.token;
            }
            case VALUE: {
                this.value = this.readNextValue();
                this.readWhitespace();
                char c = this.peekChar();
                if (c == ',') {
                    this.read();
                }
                this.token = token;
                return this.token;
            }
            case NULL: {
                this.value = null;
                Object s = this.readNextValue();
                if (!s.equals("null")) {
                    throw new IOException("Invalid stream, encountered null value with trailing data");
                }
                this.readWhitespace();
                char c = this.peekChar();
                if (c == ',') {
                    this.read();
                }
                this.token = token;
                return this.token;
            }
        }
        return null;
    }

    private char peekChar() throws IOException {
        return this.peekChar(true);
    }

    private char peekChar(boolean ws) throws IOException {
        if (ws) {
            this.readWhitespace();
        }
        if (this.limit - this.position < 1 && !this.read(1)) {
            return '\u0000';
        }
        if (this.limit - this.position > 0) {
            return this.buffer[this.position];
        }
        return '\u0000';
    }

    private boolean checkString(String value, boolean ws) throws IOException {
        int length;
        if (ws) {
            this.readWhitespace();
        }
        if (this.limit - this.position < (length = value.length()) && !this.read(length)) {
            return false;
        }
        if (this.limit - this.position < length) {
            return false;
        }
        int n = length;
        for (int i = 0; i < n; ++i) {
            if (this.buffer[this.position + i] == value.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Token peek() throws IOException {
        this.readWhitespace();
        if (this.limit - this.position < 1 && !this.read(1)) {
            return null;
        }
        if (this.limit - this.position > 0) {
            return this.toToken(this.position);
        }
        return null;
    }

    @Override
    public void skipValue() throws IOException {
        if (this.token != Token.KEY) {
            throw new IOException("Value skipping can only be used with when token is " + (Object)((Object)Token.KEY));
        }
        switch (this.peek()) {
            case OBJECT_END: 
            case LIST_END: 
            case OBJECT_START: 
            case LIST_START: {
                this.next();
                this.skip();
                break;
            }
            default: {
                this.next();
            }
        }
    }

    @Override
    public void skip() throws IOException {
        Token stop;
        switch (this.token) {
            case LIST_START: {
                stop = Token.LIST_END;
                break;
            }
            case OBJECT_START: {
                stop = Token.OBJECT_END;
                break;
            }
            default: {
                throw new IOException("Can only skip when start of object or list, token is now " + (Object)((Object)this.token));
            }
        }
        int currentLevel = this.level;
        Token next = this.peek();
        while (true) {
            if (next == null) {
                throw new IOException("No more tokens, but end of skipped value not found");
            }
            if (next == stop && this.level == currentLevel) break;
            this.next();
            next = this.peek();
        }
        this.next();
    }

    @Override
    public Token current() {
        return this.token;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean getBoolean() {
        return (Boolean)this.value;
    }

    @Override
    public double getDouble() {
        return ((Number)this.value).doubleValue();
    }

    @Override
    public float getFloat() {
        return ((Number)this.value).floatValue();
    }

    @Override
    public long getLong() {
        return ((Number)this.value).longValue();
    }

    @Override
    public int getInt() {
        return ((Number)this.value).intValue();
    }

    @Override
    public short getShort() {
        return ((Number)this.value).shortValue();
    }

    @Override
    public byte[] getByteArray() {
        String value = this.getString();
        return DatatypeConverter.parseBase64Binary((String)value);
    }
}

