/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal.reflection;

import com.google.common.base.Defaults;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.internal.reflection.FactoryDefinition;
import se.l4.commons.serialization.internal.reflection.FieldDefinition;
import se.l4.commons.serialization.internal.reflection.TypeInfo;

public class ReflectionOnlySingleFactorySerializer<T>
implements Serializer<T> {
    private final TypeInfo<T> type;
    private final FactoryDefinition<T> factory;
    private final Object[] defaultArguments;
    private final String[] names;
    private final FieldDefinition[] fields;
    private final int[] mapping;

    public ReflectionOnlySingleFactorySerializer(TypeInfo<T> type, FactoryDefinition<T> factory) {
        this.type = type;
        this.factory = factory;
        TreeMap<String, Integer> tempMapping = new TreeMap<String, Integer>();
        Object[] defaultArguments = new Object[factory.arguments.length];
        int n = factory.arguments.length;
        for (int i = 0; i < n; ++i) {
            FactoryDefinition.Argument arg = factory.arguments[i];
            if (!(arg instanceof FactoryDefinition.SerializedArgument)) continue;
            FactoryDefinition.SerializedArgument serializedArg = (FactoryDefinition.SerializedArgument)arg;
            String name = serializedArg.name;
            tempMapping.put(name, i);
            defaultArguments[i] = Defaults.defaultValue(serializedArg.type);
        }
        this.defaultArguments = defaultArguments;
        String[] names = new String[tempMapping.size()];
        FieldDefinition[] fields = new FieldDefinition[tempMapping.size()];
        int[] mapping = new int[tempMapping.size()];
        int i = 0;
        for (Map.Entry e : tempMapping.entrySet()) {
            names[i] = (String)e.getKey();
            fields[i] = type.getField((String)e.getKey());
            mapping[i] = (Integer)e.getValue();
            ++i;
        }
        this.names = names;
        this.fields = fields;
        this.mapping = mapping;
    }

    @Override
    public T read(StreamingInput in) throws IOException {
        in.next(Token.OBJECT_START);
        Object[] args = Arrays.copyOf(this.defaultArguments, this.defaultArguments.length);
        while (in.peek() != Token.OBJECT_END) {
            in.next(Token.KEY);
            String key = in.getString();
            int idx = Arrays.binarySearch(this.names, key);
            if (idx >= 0) {
                args[this.mapping[idx]] = this.fields[idx].read(in);
                continue;
            }
            in.skipValue();
        }
        in.next(Token.OBJECT_END);
        return this.factory.create(args);
    }

    @Override
    public void write(T object, String name, StreamingOutput stream) throws IOException {
        stream.writeObjectStart(name);
        for (FieldDefinition def : this.type.getAllFields()) {
            def.write(object, stream);
        }
        stream.writeObjectEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.type.getFormatDefinition();
    }
}

