/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.config;

import java.io.IOException;
import se.l4.commons.config.Config;
import se.l4.commons.config.Value;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.format.ValueType;

public class ConfigKey {
    public static final String NAME = "_aurochs_:configKey";
    private final Config config;
    private final String key;

    private ConfigKey(Config config, String key) {
        this.config = config;
        this.key = key;
    }

    public <T> Value<T> get(String subPath, Class<T> type) {
        return this.config.get(this.key + '.' + subPath, type);
    }

    public <T> T asObject(String subPath, Class<T> type) {
        return this.config.asObject(this.key + '.' + subPath, type);
    }

    public <T> T asObject(Class<T> type) {
        return this.config.asObject(this.key, type);
    }

    public static class ConfigKeySerializer
    implements Serializer<ConfigKey> {
        private final Config config;

        public ConfigKeySerializer(Config config) {
            this.config = config;
        }

        @Override
        public ConfigKey read(StreamingInput in) throws IOException {
            in.next(Token.VALUE);
            return new ConfigKey(this.config, in.getString());
        }

        @Override
        public void write(ConfigKey object, String name, StreamingOutput stream) throws IOException {
        }

        @Override
        public SerializerFormatDefinition getFormatDefinition() {
            return SerializerFormatDefinition.forValue(ValueType.STRING);
        }
    }
}

