/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.internal.reflection;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import se.l4.commons.serialization.Serializer;
import se.l4.commons.serialization.SerializerFormatDefinition;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.StreamingOutput;
import se.l4.commons.serialization.format.Token;
import se.l4.commons.serialization.internal.reflection.FieldDefinition;
import se.l4.commons.serialization.internal.reflection.TypeInfo;

public class ReflectionNonStreamingSerializer<T>
implements Serializer<T> {
    private final TypeInfo<T> type;

    public ReflectionNonStreamingSerializer(TypeInfo<T> type) {
        this.type = type;
    }

    @Override
    public T read(StreamingInput in) throws IOException {
        in.next(Token.OBJECT_START);
        HashMap<String, Object> data = new HashMap<String, Object>();
        while (in.peek() != Token.OBJECT_END) {
            in.next(Token.KEY);
            String key = in.getString();
            FieldDefinition def = this.type.getField(key);
            if (def == null) {
                in.skipValue();
                continue;
            }
            data.put(key, def.read(in));
        }
        in.next(Token.OBJECT_END);
        T instance = this.type.newInstance(data);
        for (Map.Entry entry : data.entrySet()) {
            FieldDefinition def = this.type.getField((String)entry.getKey());
            if (def.isReadOnly()) continue;
            def.set(instance, entry.getValue());
        }
        return instance;
    }

    @Override
    public void write(T object, String name, StreamingOutput stream) throws IOException {
        stream.writeObjectStart(name);
        for (FieldDefinition def : this.type.getAllFields()) {
            def.write(object, stream);
        }
        stream.writeObjectEnd(name);
    }

    @Override
    public SerializerFormatDefinition getFormatDefinition() {
        return this.type.getFormatDefinition();
    }
}

