/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.format;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.bind.DatatypeConverter;
import se.l4.commons.serialization.format.AbstractStreamingInput;
import se.l4.commons.serialization.format.Token;

public class JsonInput
extends AbstractStreamingInput {
    private static final char NULL = '\u0000';
    private final Reader in;
    private final char[] buffer;
    private int position;
    private int limit;
    private final boolean[] lists;

    public JsonInput(InputStream in) {
        this(new InputStreamReader(in));
    }

    public JsonInput(Reader in) {
        this.in = in;
        this.lists = new boolean[20];
        this.buffer = new char[1024];
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private void readWhitespace() throws IOException {
        if (this.limit - this.position > 0 && !Character.isWhitespace(this.buffer[this.position])) {
            return;
        }
        while (true) {
            if (this.limit - this.position < 1 && !this.readAhead(1)) {
                return;
            }
            char c = this.buffer[this.position];
            if (!Character.isWhitespace(c) && c != ',') break;
            ++this.position;
        }
    }

    private char readNext() throws IOException {
        this.readWhitespace();
        return this.read();
    }

    private char read() throws IOException {
        if (this.limit - this.position < 1 && !this.readAhead(1)) {
            throw new EOFException();
        }
        return this.buffer[this.position++];
    }

    private boolean readAhead(int minChars) throws IOException {
        if (this.limit < 0) {
            return false;
        }
        if (this.position + minChars < this.limit) {
            return true;
        }
        if (this.limit >= this.position) {
            int stop = this.limit - this.position;
            System.arraycopy(this.buffer, this.position, this.buffer, 0, stop);
            this.limit = stop;
        } else {
            this.limit = 0;
        }
        int read = this.read(this.buffer, this.limit, this.buffer.length - this.limit);
        this.position = 0;
        this.limit += read;
        if (read == 0) {
            return false;
        }
        if (read < minChars) {
            throw new IOException("Needed " + minChars + " but got " + read);
        }
        return true;
    }

    private int read(char[] buffer, int offset, int length) throws IOException {
        int result;
        int l;
        for (result = 0; result < length && (l = this.in.read(buffer, offset + result, length - result)) != -1; result += l) {
        }
        return result;
    }

    private Token toToken(char c) {
        switch (c) {
            case '{': {
                return Token.OBJECT_START;
            }
            case '}': {
                return Token.OBJECT_END;
            }
            case '[': {
                return Token.LIST_START;
            }
            case ']': {
                return Token.LIST_END;
            }
            case '\"': {
                if (this.current() == Token.KEY || this.lists[this.level]) break;
                return Token.KEY;
            }
        }
        if (c == 'n') {
            return Token.NULL;
        }
        return Token.VALUE;
    }

    private Object readNextValue() throws IOException {
        char c = this.readNext();
        if (c == '\"') {
            return this.readString(false);
        }
        StringBuilder value = new StringBuilder();
        block3: while (true) {
            value.append(c);
            c = this.peekChar(false);
            switch (c) {
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    break block3;
                }
                default: {
                    if (Character.isWhitespace(c)) break block3;
                    this.read();
                    continue block3;
                }
            }
            break;
        }
        return this.toObject(value.toString());
    }

    private Object toObject(String in) {
        if (in.equals("false")) {
            return false;
        }
        if (in.equals("true")) {
            return true;
        }
        try {
            return Long.parseLong(in);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(in);
            }
            catch (NumberFormatException numberFormatException) {
                return in;
            }
        }
    }

    private String readString(boolean readStart) throws IOException {
        StringBuilder key = new StringBuilder();
        char c = this.read();
        if (readStart) {
            if (c != '\"') {
                throw new IOException("Expected \", but got " + c);
            }
            c = this.read();
        }
        while (c != '\"') {
            if (c == '\\') {
                this.readEscaped(key);
            } else {
                key.append(c);
            }
            c = this.read();
        }
        return key.toString();
    }

    private void readEscaped(StringBuilder result) throws IOException {
        char c = this.read();
        switch (c) {
            case '\'': {
                result.append('\'');
                break;
            }
            case '\"': {
                result.append('\"');
                break;
            }
            case '\\': {
                result.append('\\');
                break;
            }
            case '/': {
                result.append('/');
                break;
            }
            case 'r': {
                result.append('\r');
                break;
            }
            case 'n': {
                result.append('\n');
                break;
            }
            case 't': {
                result.append('\t');
                break;
            }
            case 'b': {
                result.append('\b');
                break;
            }
            case 'f': {
                result.append('\f');
                break;
            }
            case 'u': {
                this.readAhead(4);
                String s = new String(this.buffer, this.position, 4);
                result.append((char)Integer.parseInt(s, 16));
                this.position += 4;
            }
        }
    }

    @Override
    public Token next(Token expected) throws IOException {
        Token t = this.next();
        if (t != expected) {
            throw new IOException("Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)t));
        }
        return t;
    }

    @Override
    public Token next0() throws IOException {
        Token token = this.toToken(this.peekChar());
        switch (token) {
            case OBJECT_END: 
            case LIST_END: {
                this.readNext();
                char c = this.peekChar();
                if (c == ',') {
                    this.read();
                }
                return token;
            }
            case OBJECT_START: 
            case LIST_START: {
                this.readNext();
                this.lists[this.level + 1] = token == Token.LIST_START;
                return token;
            }
            case KEY: {
                this.readWhitespace();
                String key = this.readString(true);
                char next = this.readNext();
                if (next != ':') {
                    throw new IOException("Expected :, got " + next);
                }
                this.setValue(key);
                return token;
            }
            case VALUE: {
                this.setValue(this.readNextValue());
                this.readWhitespace();
                char c = this.peekChar();
                if (c == ',') {
                    this.read();
                }
                return token;
            }
            case NULL: {
                this.readNextValue();
                this.setValue(null);
                this.readWhitespace();
                char c = this.peekChar();
                if (c == ',') {
                    this.read();
                }
                return token;
            }
        }
        return null;
    }

    private char peekChar() throws IOException {
        return this.peekChar(true);
    }

    private char peekChar(boolean ws) throws IOException {
        if (ws) {
            this.readWhitespace();
        }
        if (this.limit - this.position < 1 && !this.readAhead(1)) {
            return '\u0000';
        }
        if (this.limit - this.position > 0) {
            return this.buffer[this.position];
        }
        return '\u0000';
    }

    @Override
    public Token peek() throws IOException {
        this.readWhitespace();
        if (this.limit - this.position < 1 && !this.readAhead(1)) {
            return null;
        }
        if (this.limit - this.position > 0) {
            return this.toToken(this.buffer[this.position]);
        }
        return null;
    }

    @Override
    public byte[] getByteArray() {
        String value = this.getString();
        return DatatypeConverter.parseBase64Binary((String)value);
    }
}

