/*
 * Decompiled with CFR 0.152.
 */
package se.l4.commons.serialization.format;

import java.io.IOException;
import se.l4.commons.serialization.format.StreamingInput;
import se.l4.commons.serialization.format.Token;

public abstract class AbstractStreamingInput
implements StreamingInput {
    private Object value;
    private Token token;
    protected int level;

    protected void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Token next() throws IOException {
        Token token = this.next0();
        switch (token) {
            case OBJECT_END: 
            case LIST_END: {
                --this.level;
                break;
            }
            case OBJECT_START: 
            case LIST_START: {
                ++this.level;
                break;
            }
        }
        this.token = token;
        return this.token;
    }

    protected abstract Token next0() throws IOException;

    protected IOException raiseException(String message) {
        return new IOException(message);
    }

    @Override
    public Token next(Token expected) throws IOException {
        Token t = this.next();
        if (t != expected) {
            throw this.raiseException("Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)t));
        }
        return t;
    }

    @Override
    public void skipValue() throws IOException {
        if (this.token != Token.KEY) {
            throw this.raiseException("Value skipping can only be used with when token is " + (Object)((Object)Token.KEY));
        }
        switch (this.peek()) {
            case OBJECT_END: 
            case LIST_END: 
            case OBJECT_START: 
            case LIST_START: {
                this.next();
                this.skip();
                break;
            }
            default: {
                this.next();
            }
        }
    }

    @Override
    public void skip() throws IOException {
        Token stop;
        switch (this.token) {
            case LIST_START: {
                stop = Token.LIST_END;
                break;
            }
            case OBJECT_START: {
                stop = Token.OBJECT_END;
                break;
            }
            default: {
                throw this.raiseException("Can only skip when start of object or list, token is now " + (Object)((Object)this.token));
            }
        }
        int currentLevel = this.level;
        Token next = this.peek();
        while (true) {
            if (next == null) {
                throw this.raiseException("No more tokens, but end of skipped value not found");
            }
            if (next == stop && this.level == currentLevel) break;
            this.next();
            next = this.peek();
        }
        this.next();
    }

    @Override
    public Token current() {
        return this.token;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getString() {
        return (String)this.value;
    }

    @Override
    public boolean getBoolean() {
        return (Boolean)this.value;
    }

    @Override
    public double getDouble() {
        return ((Number)this.value).doubleValue();
    }

    @Override
    public float getFloat() {
        return ((Number)this.value).floatValue();
    }

    @Override
    public long getLong() {
        return ((Number)this.value).longValue();
    }

    @Override
    public int getInt() {
        return ((Number)this.value).intValue();
    }

    @Override
    public short getShort() {
        return ((Number)this.value).shortValue();
    }

    @Override
    public byte[] getByteArray() {
        return (byte[])this.value;
    }
}

