/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventorFactory;
import se.jiderhamn.classloader.leak.prevention.cleanup.ShutdownHookCleanUp;
import se.jiderhamn.classloader.leak.prevention.cleanup.StopThreadsCleanUp;
import se.jiderhamn.classloader.leak.prevention.preinit.OracleJdbcThreadInitiator;

public class ClassLoaderLeakPreventorListener
implements ServletContextListener {
    protected ClassLoaderLeakPreventor classLoaderLeakPreventor;
    protected final List<ServletContextListener> otherListeners = new LinkedList<ServletContextListener>();

    static List<ServletContextListener> getDefaultOtherListeners() {
        try {
            Class<?> introspectorCleanupListenerClass = Class.forName("org.springframework.web.util.IntrospectorCleanupListener");
            return Collections.singletonList(introspectorCleanupListenerClass.newInstance());
        }
        catch (ClassNotFoundException introspectorCleanupListenerClass) {
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return Collections.emptyList();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.otherListeners.addAll(ClassLoaderLeakPreventorListener.getDefaultOtherListeners());
        this.contextInitialized(servletContextEvent.getServletContext());
        for (ServletContextListener listener : this.otherListeners) {
            try {
                listener.contextInitialized(servletContextEvent);
            }
            catch (Exception e) {
                this.classLoaderLeakPreventor.error((Throwable)e);
            }
        }
    }

    void contextInitialized(ServletContext servletContext) {
        boolean stopThreads = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.stopThreads"));
        boolean stopTimerThreads = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.stopTimerThreads"));
        boolean executeShutdownHooks = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.executeShutdownHooks"));
        boolean startOracleTimeoutThread = !"false".equals(servletContext.getInitParameter("ClassLoaderLeakPreventor.startOracleTimeoutThread"));
        int threadWaitMs = ClassLoaderLeakPreventorListener.getIntInitParameter(servletContext, "ClassLoaderLeakPreventor.threadWaitMs", 5000);
        int shutdownHookWaitMs = ClassLoaderLeakPreventorListener.getIntInitParameter(servletContext, "ClassLoaderLeakPreventor.shutdownHookWaitMs", 10000);
        ClassLoader webAppClassLoader = Thread.currentThread().getContextClassLoader();
        this.info("Settings for " + this.getClass().getName() + " (CL: 0x" + Integer.toHexString(System.identityHashCode(webAppClassLoader)) + "):");
        this.info("  stopThreads = " + stopThreads);
        this.info("  stopTimerThreads = " + stopTimerThreads);
        this.info("  executeShutdownHooks = " + executeShutdownHooks);
        this.info("  threadWaitMs = " + threadWaitMs + " ms");
        this.info("  shutdownHookWaitMs = " + shutdownHookWaitMs + " ms");
        ClassLoaderLeakPreventorFactory classLoaderLeakPreventorFactory = this.createClassLoaderLeakPreventorFactory();
        if (!startOracleTimeoutThread) {
            classLoaderLeakPreventorFactory.removePreInitiator(OracleJdbcThreadInitiator.class);
        }
        ShutdownHookCleanUp shutdownHookCleanUp = (ShutdownHookCleanUp)classLoaderLeakPreventorFactory.getCleanUp(ShutdownHookCleanUp.class);
        shutdownHookCleanUp.setExecuteShutdownHooks(executeShutdownHooks);
        shutdownHookCleanUp.setShutdownHookWaitMs(shutdownHookWaitMs);
        StopThreadsCleanUp stopThreadsCleanUp = (StopThreadsCleanUp)classLoaderLeakPreventorFactory.getCleanUp(StopThreadsCleanUp.class);
        stopThreadsCleanUp.setStopThreads(stopThreads);
        stopThreadsCleanUp.setStopTimerThreads(stopTimerThreads);
        stopThreadsCleanUp.setThreadWaitMs(threadWaitMs);
        this.classLoaderLeakPreventor = classLoaderLeakPreventorFactory.newLeakPreventor(webAppClassLoader);
        this.classLoaderLeakPreventor.runPreClassLoaderInitiators();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.info(this.getClass().getName() + " shutting down context by removing known leaks (CL: 0x" + Integer.toHexString(System.identityHashCode(this.classLoaderLeakPreventor.getClassLoader())) + ")");
        for (ServletContextListener listener : this.otherListeners) {
            try {
                listener.contextDestroyed(servletContextEvent);
            }
            catch (Exception e) {
                this.classLoaderLeakPreventor.error((Throwable)e);
            }
        }
        this.classLoaderLeakPreventor.runCleanUps();
    }

    protected ClassLoaderLeakPreventorFactory createClassLoaderLeakPreventorFactory() {
        return new ClassLoaderLeakPreventorFactory();
    }

    protected static int getIntInitParameter(ServletContext servletContext, String parameterName, int defaultValue) {
        String parameterString = servletContext.getInitParameter(parameterName);
        if (parameterString != null && parameterString.trim().length() > 0) {
            try {
                return Integer.parseInt(parameterString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected String getLogPrefix() {
        return ClassLoaderLeakPreventorListener.class.getSimpleName() + ": ";
    }

    protected void info(String s) {
        System.out.println(this.getLogPrefix() + s);
    }
}

