/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.preinit;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.PreClassLoaderInitiator;
import se.jiderhamn.classloader.leak.prevention.ReplaceDOMNormalizerSerializerAbortException;

public class OracleJdbcThreadInitiator
implements PreClassLoaderInitiator {
    @Override
    public void doOutsideClassLoader(ClassLoaderLeakPreventor preventor) {
        try {
            Class.forName("oracle.jdbc.driver.OracleTimeoutThreadPerVM");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("oracle.jdbc.driver.BlockSource$ThreadedCachingBlockSource$BlockReleaser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("oracle.net.nt.TimeoutInterruptHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("oracle.jdbc.driver.NoSupportHAManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            Class<?> oracleDiagnosabilityMBeanClass = Class.forName("oracle.jdbc.driver.OracleDiagnosabilityMBean");
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> mBeanNames = mBeanServer.queryNames(new ObjectName("com.oracle.jdbc:type=diagnosability,*"), null);
            for (ObjectName mBeanName : mBeanNames) {
                Object oracleDiagnosabilityMBean = oracleDiagnosabilityMBeanClass.newInstance();
                Object traceController = preventor.getFieldValue(oracleDiagnosabilityMBean, "tc");
                if (traceController != null) {
                    Field reSuspendedField = preventor.findField(traceController.getClass(), "reSuspended");
                    if (reSuspendedField != null) {
                        Object oldValue = reSuspendedField.get(traceController);
                        reSuspendedField.set(traceController, ReplaceDOMNormalizerSerializerAbortException.constructRuntimeExceptionWithoutStackTrace(preventor, oldValue instanceof Exception ? ((Exception)oldValue).getMessage() : "trace controller is currently suspended", null));
                        preventor.info("Replacing MBean " + mBeanName + " with " + reSuspendedField.getName() + " field of " + traceController + " replaced to avoid backtrace references.");
                        mBeanServer.unregisterMBean(mBeanName);
                        mBeanServer.registerMBean(oracleDiagnosabilityMBean, mBeanName);
                        continue;
                    }
                    preventor.warn("Unable to find 'reSuspended' field of " + traceController);
                    continue;
                }
                preventor.warn("Found " + oracleDiagnosabilityMBeanClass + " but it has no 'tm' TraceController attribute");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

