/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.X509TrustManager;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class X509TrustManagerImplUnparseableExtensionCleanUp
implements ClassLoaderPreMortemCleanUp {
    private static final String SUN_SECURITY_X509_X509_CERT_IMPL = "sun.security.x509.X509CertImpl";

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        SSLContextSpi sslContext = (SSLContextSpi)preventor.getStaticFieldValue("sun.security.ssl.SSLContextImpl$DefaultSSLContext", "defaultImpl");
        if (sslContext != null) {
            Field trustManagerField = preventor.findFieldOfClass("sun.security.ssl.SSLContextImpl", "trustManager");
            Method get = preventor.findMethod(SUN_SECURITY_X509_X509_CERT_IMPL, "get", String.class);
            Method getUnparseableExtensions = preventor.findMethod("sun.security.x509.CertificateExtensions", "getUnparseableExtensions", new Class[0]);
            Field why = preventor.findFieldOfClass("sun.security.x509.UnparseableExtension", "why");
            if (trustManagerField != null && get != null && getUnparseableExtensions != null && why != null) {
                X509TrustManager trustManager = (X509TrustManager)preventor.getFieldValue(trustManagerField, sslContext);
                for (X509Certificate x509Certificate : trustManager.getAcceptedIssuers()) {
                    if (!SUN_SECURITY_X509_X509_CERT_IMPL.equals(x509Certificate.getClass().getName())) continue;
                    try {
                        Object extensions = get.invoke((Object)x509Certificate, "x509.info.extensions");
                        if (extensions == null) continue;
                        Map unparseableExtensions = (Map)getUnparseableExtensions.invoke(extensions, new Object[0]);
                        for (Object unparseableExtension : unparseableExtensions.values()) {
                            if (why.get(unparseableExtension) == null) continue;
                            preventor.warn(trustManager + " cached X509Certificate that had unparseable extension; removing 'why': " + x509Certificate);
                            why.set(unparseableExtension, null);
                        }
                    }
                    catch (Exception e) {
                        preventor.error(e);
                    }
                }
            }
        }
    }
}

