/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Method;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;
import se.jiderhamn.classloader.leak.prevention.MustBeAfter;
import se.jiderhamn.classloader.leak.prevention.cleanup.JavaServerFaces2746CleanUp;

public class ThreadGroupCleanUp
implements ClassLoaderPreMortemCleanUp,
MustBeAfter {
    public Class[] mustBeBeforeMe() {
        return new Class[]{JavaServerFaces2746CleanUp.class};
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        boolean threadGroupDestroyed = false;
        try {
            ThreadGroup[] allThreadGroups;
            int enumeratedGroups;
            ThreadGroup systemThreadGroup = Thread.currentThread().getThreadGroup();
            while (systemThreadGroup.getParent() != null) {
                systemThreadGroup = systemThreadGroup.getParent();
            }
            int noOfGroups = systemThreadGroup.activeGroupCount();
            while ((enumeratedGroups = systemThreadGroup.enumerate(allThreadGroups = new ThreadGroup[noOfGroups += 10])) >= noOfGroups) {
            }
            for (ThreadGroup threadGroup : allThreadGroups) {
                if (!preventor.isLoadedInClassLoader(threadGroup) || threadGroup.isDestroyed()) continue;
                preventor.warn("ThreadGroup '" + threadGroup + "' was loaded inside application, needs to be destroyed");
                int noOfThreads = threadGroup.activeCount();
                if (noOfThreads > 0) {
                    preventor.warn("There seems to be " + noOfThreads + " running in ThreadGroup '" + threadGroup + "'; interrupting");
                    try {
                        threadGroup.interrupt();
                    }
                    catch (Exception e) {
                        preventor.error(e);
                    }
                }
                try {
                    threadGroup.destroy();
                    threadGroupDestroyed = true;
                    preventor.info("ThreadGroup '" + threadGroup + "' successfully destroyed");
                }
                catch (Exception e) {
                    preventor.error(e);
                }
            }
        }
        catch (Exception ex) {
            preventor.error(ex);
        }
        try {
            Object contexts = preventor.getStaticFieldValue("java.beans.ThreadGroupContext", "contexts");
            if (contexts != null) {
                Method removeStaleEntries;
                if (threadGroupDestroyed) {
                    ClassLoaderLeakPreventor.gc();
                }
                if ((removeStaleEntries = preventor.findMethod("java.beans.WeakIdentityMap", "removeStaleEntries", new Class[0])) != null) {
                    removeStaleEntries.invoke(contexts, new Object[0]);
                }
            }
        }
        catch (Throwable t) {
            preventor.warn(t);
        }
    }
}

