/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.Map;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class MoxyCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Class<?> propertyClass;
        Class<?> helperClass = this.findClass(preventor, "org.eclipse.persistence.jaxb.javamodel.Helper");
        if (helperClass != null) {
            this.unsetField(preventor, helperClass, "COLLECTION_CLASS");
            this.unsetField(preventor, helperClass, "LIST_CLASS");
            this.unsetField(preventor, helperClass, "SET_CLASS");
            this.unsetField(preventor, helperClass, "MAP_CLASS");
            this.unsetField(preventor, helperClass, "JAXBELEMENT_CLASS");
            this.unsetField(preventor, helperClass, "OBJECT_CLASS");
        }
        if ((propertyClass = this.findClass(preventor, "org.eclipse.persistence.jaxb.compiler.Property")) != null) {
            this.unsetField(preventor, propertyClass, "OBJECT_CLASS");
            this.unsetField(preventor, propertyClass, "XML_ADAPTER_CLASS");
        }
    }

    public Class<?> findClass(ClassLoaderLeakPreventor preventor, String className) {
        try {
            return Class.forName(className, true, preventor.getLeakSafeClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception ex) {
            preventor.warn(ex);
            return null;
        }
    }

    private void unsetField(ClassLoaderLeakPreventor preventor, Class<?> clazz, String fieldName) {
        block12: {
            Field field = preventor.findField(clazz, fieldName);
            if (field != null) {
                try {
                    Object javaClass = field.get(null);
                    if (javaClass == null) break block12;
                    Object javaModelImpl = preventor.getFieldValue(javaClass, "javaModelImpl");
                    if (javaModelImpl != null) {
                        Method getClassLoader = preventor.findMethod(javaModelImpl.getClass(), "getClassLoader", new Class[0]);
                        if (getClassLoader != null) {
                            ClassLoader classLoader = (ClassLoader)getClassLoader.invoke(javaModelImpl, new Object[0]);
                            if (preventor.isClassLoaderOrChild(classLoader)) {
                                preventor.info("Changing ClassLoader of " + field);
                                preventor.findMethod(javaModelImpl.getClass(), "setClassLoader", ClassLoader.class).invoke(javaModelImpl, preventor.getLeakSafeClassLoader());
                                Field isJaxbClassLoader = preventor.findField(javaModelImpl.getClass(), "isJaxbClassLoader");
                                if (isJaxbClassLoader != null) {
                                    isJaxbClassLoader.set(javaModelImpl, false);
                                }
                            }
                        } else {
                            preventor.error("Cannot get ClassLoader of " + javaModelImpl);
                        }
                        Map cachedJavaClasses = (Map)preventor.getFieldValue(javaModelImpl, "cachedJavaClasses");
                        if (cachedJavaClasses != null) {
                            try {
                                cachedJavaClasses.clear();
                            }
                            catch (ConcurrentModificationException e) {
                                preventor.error("Unable to clear " + javaModelImpl + ".cachedJavaClasses");
                            }
                        }
                        break block12;
                    }
                    preventor.error("Cannot get javaModelImpl of " + javaClass);
                    field.set(null, null);
                }
                catch (Exception e) {
                    preventor.warn(e);
                }
            } else {
                preventor.warn("Unable to find field " + fieldName + " of class " + clazz);
            }
        }
    }
}

