/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.management.ManagementFactory;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class MXBeanNotificationListenersCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Set<Class<? extends PlatformManagedObject>> platformInterfaces;
        boolean canProcessNotificationEmitterSupport;
        Class<?> notificationEmitterSupportClass = preventor.findClass("sun.management.NotificationEmitterSupport");
        Field listenerListField = preventor.findField(notificationEmitterSupportClass, "listenerList");
        Class<?> listenerInfoClass = preventor.findClass("sun.management.NotificationEmitterSupport$ListenerInfo");
        Field listenerField = preventor.findField(listenerInfoClass, "listener");
        Field filterField = preventor.findField(listenerInfoClass, "filter");
        Field handbackField = preventor.findField(listenerInfoClass, "handback");
        Class<?> listenerWrapperClass = preventor.findClass("com.sun.jmx.interceptor.DefaultMBeanServerInterceptor$ListenerWrapper");
        boolean bl = canProcessNotificationEmitterSupport = listenerListField != null && listenerInfoClass != null && listenerField != null && filterField != null && handbackField != null;
        if (!canProcessNotificationEmitterSupport) {
            preventor.warn("Unable to unregister NotificationEmitterSupport listeners, because details could not be found using reflection");
        }
        if ((platformInterfaces = ManagementFactory.getPlatformManagementInterfaces()) != null) {
            for (Class<? extends PlatformManagedObject> platformInterface : platformInterfaces) {
                for (PlatformManagedObject platformManagedObject : ManagementFactory.getPlatformMXBeans(platformInterface)) {
                    if (!(platformManagedObject instanceof NotificationEmitter)) continue;
                    if (canProcessNotificationEmitterSupport && notificationEmitterSupportClass.isAssignableFrom(platformManagedObject.getClass())) {
                        List listenerList = (List)preventor.getFieldValue(listenerListField, platformManagedObject);
                        if (listenerList == null) continue;
                        for (Object listenerInfo : listenerList) {
                            NotificationListener listener = (NotificationListener)preventor.getFieldValue(listenerField, listenerInfo);
                            NotificationListener rawListener = this.unwrap(preventor, listenerWrapperClass, listener);
                            NotificationFilter filter = (NotificationFilter)preventor.getFieldValue(filterField, listenerInfo);
                            Object handback = preventor.getFieldValue(handbackField, listenerInfo);
                            if (!preventor.isLoadedInClassLoader(rawListener) && !preventor.isLoadedInClassLoader(filter) && !preventor.isLoadedInClassLoader(handback)) continue;
                            preventor.warn((listener == rawListener ? "Listener '" : "Wrapped listener '") + listener + "' (or its filter or handback) of MXBean " + platformManagedObject + " of PlatformManagedObject " + platformInterface + " was loaded in protected ClassLoader; removing");
                            try {
                                ((NotificationEmitter)((Object)platformManagedObject)).removeNotificationListener(listener, filter, handback);
                            }
                            catch (ListenerNotFoundException e) {
                                preventor.error(e);
                            }
                        }
                        continue;
                    }
                    if (!(platformManagedObject instanceof NotificationBroadcasterSupport)) continue;
                    this.unregisterNotificationListeners(preventor, (NotificationBroadcasterSupport)((Object)platformManagedObject), listenerWrapperClass);
                }
            }
        }
    }

    protected void unregisterNotificationListeners(ClassLoaderLeakPreventor preventor, NotificationBroadcasterSupport mBean, Class<?> listenerWrapperClass) {
        Field listenerListField = preventor.findField(NotificationBroadcasterSupport.class, "listenerList");
        if (listenerListField != null) {
            Class<?> listenerInfoClass = preventor.findClass("javax.management.NotificationBroadcasterSupport$ListenerInfo");
            List listenerList = (List)preventor.getFieldValue(listenerListField, mBean);
            if (listenerList != null) {
                Field listenerField = preventor.findField(listenerInfoClass, "listener");
                Field filterField = preventor.findField(listenerInfoClass, "filter");
                Field handbackField = preventor.findField(listenerInfoClass, "handback");
                for (Object listenerInfo : listenerList) {
                    NotificationListener listener = (NotificationListener)preventor.getFieldValue(listenerField, listenerInfo);
                    NotificationListener rawListener = this.unwrap(preventor, listenerWrapperClass, listener);
                    NotificationFilter filter = (NotificationFilter)preventor.getFieldValue(filterField, listenerInfo);
                    Object handback = preventor.getFieldValue(handbackField, listenerInfo);
                    if (!preventor.isLoadedInClassLoader(rawListener) && !preventor.isLoadedInClassLoader(filter) && !preventor.isLoadedInClassLoader(handback)) continue;
                    preventor.warn((listener == rawListener ? "Listener '" : "Wrapped listener '") + listener + "' (or its filter or handback) of MBean " + mBean + " was loaded in protected ClassLoader; removing");
                    try {
                        mBean.removeNotificationListener(listener, filter, handback);
                    }
                    catch (ListenerNotFoundException e) {
                        preventor.error(e);
                    }
                }
            }
        }
    }

    private NotificationListener unwrap(ClassLoaderLeakPreventor preventor, Class<?> listenerWrapperClass, NotificationListener listener) {
        if (listenerWrapperClass != null && listenerWrapperClass.isInstance(listener)) {
            return (NotificationListener)preventor.getFieldValue(listener, "listener");
        }
        return listener;
    }
}

