/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;

public class MBeanCleanUp
implements ClassLoaderPreMortemCleanUp {
    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> allMBeanNames = mBeanServer.queryNames(new ObjectName("*:*"), null);
            JettyJMXRemover jettyJMXRemover = null;
            if (this.isJettyWithJMX(preventor)) {
                try {
                    jettyJMXRemover = new JettyJMXRemover(preventor);
                }
                catch (Exception ex) {
                    preventor.error(ex);
                }
            }
            for (ObjectName objectName : allMBeanNames) {
                try {
                    ClassLoader mBeanClassLoader;
                    if (jettyJMXRemover != null && jettyJMXRemover.unregisterJettyJMXBean(objectName) || !preventor.isClassLoaderOrChild(mBeanClassLoader = mBeanServer.getClassLoaderFor(objectName))) continue;
                    preventor.warn("MBean '" + objectName + "' was loaded by protected ClassLoader; unregistering");
                    mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    preventor.error(e);
                }
            }
        }
        catch (Exception e) {
            preventor.error(e);
        }
    }

    protected boolean isJettyWithJMX(ClassLoaderLeakPreventor preventor) {
        ClassLoader classLoader = preventor.getClassLoader();
        try {
            if (classLoader.getResource("org/eclipse/jetty") == null) {
                return false;
            }
            Class.forName("org.eclipse.jetty.jmx.MBeanContainer", false, classLoader.getParent());
            Class.forName("org.eclipse.jetty.webapp.WebAppContext", false, classLoader.getParent());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private class JettyJMXRemover {
        private final ClassLoaderLeakPreventor preventor;
        private List<Object> objectsWrappedWithMBean;
        private Object beanContainer;
        private Method findBeanMethod;
        private Method removeBeanMethod;

        public JettyJMXRemover(ClassLoaderLeakPreventor preventor) throws Exception {
            this.preventor = preventor;
            Object webappContext = this.findJettyClass("org.eclipse.jetty.webapp.WebAppClassLoader").getMethod("getContext", new Class[0]).invoke((Object)preventor.getClassLoader(), new Object[0]);
            if (webappContext == null) {
                return;
            }
            Class webAppContextClass = this.findJettyClass("org.eclipse.jetty.webapp.WebAppContext");
            Object server = webAppContextClass.getMethod("getServer", new Class[0]).invoke(webappContext, new Object[0]);
            if (server == null) {
                return;
            }
            Class mBeanContainerClass = this.findJettyClass("org.eclipse.jetty.jmx.MBeanContainer");
            this.beanContainer = this.findJettyClass("org.eclipse.jetty.server.Server").getMethod("getBean", Class.class).invoke(server, mBeanContainerClass);
            if (this.beanContainer != null) {
                this.findBeanMethod = mBeanContainerClass.getMethod("findBean", ObjectName.class);
                try {
                    this.removeBeanMethod = mBeanContainerClass.getMethod("removeBean", Object.class);
                }
                catch (NoSuchMethodException e) {
                    preventor.warn("MBeanContainer.removeBean() method can not be found. giving up");
                    return;
                }
                this.objectsWrappedWithMBean = new ArrayList<Object>();
                Object sessionHandler = webAppContextClass.getMethod("getSessionHandler", new Class[0]).invoke(webappContext, new Object[0]);
                if (sessionHandler != null) {
                    this.objectsWrappedWithMBean.add(sessionHandler);
                    Object sessionManager = this.findJettyClass("org.eclipse.jetty.server.session.SessionHandler").getMethod("getSessionManager", new Class[0]).invoke(sessionHandler, new Object[0]);
                    if (sessionManager != null) {
                        this.objectsWrappedWithMBean.add(sessionManager);
                        Object sessionIdManager = this.findJettyClass("org.eclipse.jetty.server.SessionManager").getMethod("getSessionIdManager", new Class[0]).invoke(sessionManager, new Object[0]);
                        this.objectsWrappedWithMBean.add(sessionIdManager);
                    }
                }
                this.objectsWrappedWithMBean.add(webAppContextClass.getMethod("getSecurityHandler", new Class[0]).invoke(webappContext, new Object[0]));
                Object servletHandler = webAppContextClass.getMethod("getServletHandler", new Class[0]).invoke(webappContext, new Object[0]);
                if (servletHandler != null) {
                    this.objectsWrappedWithMBean.add(servletHandler);
                    Class servletHandlerClass = this.findJettyClass("org.eclipse.jetty.servlet.ServletHandler");
                    this.objectsWrappedWithMBean.add(Arrays.asList((Object[])servletHandlerClass.getMethod("getServletMappings", new Class[0]).invoke(servletHandler, new Object[0])));
                    this.objectsWrappedWithMBean.add(Arrays.asList((Object[])servletHandlerClass.getMethod("getServlets", new Class[0]).invoke(servletHandler, new Object[0])));
                }
            }
        }

        boolean unregisterJettyJMXBean(ObjectName objectName) {
            if (this.objectsWrappedWithMBean == null || !objectName.getDomain().contains("org.eclipse.jetty")) {
                return false;
            }
            try {
                Object bean = this.findBeanMethod.invoke(this.beanContainer, objectName);
                if (bean == null) {
                    return false;
                }
                for (Object wrapped : this.objectsWrappedWithMBean) {
                    if (wrapped != bean) continue;
                    this.preventor.warn("Jetty MBean '" + objectName + "' is a suspect in causing memory leaks; unregistering");
                    this.removeBeanMethod.invoke(this.beanContainer, bean);
                    return true;
                }
            }
            catch (Exception ex) {
                this.preventor.error(ex);
            }
            return false;
        }

        Class findJettyClass(String className) throws ClassNotFoundException {
            try {
                return Class.forName(className, false, this.preventor.getClassLoader());
            }
            catch (ClassNotFoundException e1) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e2) {
                    e2.addSuppressed(e1);
                    throw e2;
                }
            }
        }
    }
}

