/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention.cleanup;

import se.jiderhamn.classloader.leak.prevention.ClassLoaderLeakPreventor;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;
import se.jiderhamn.classloader.leak.prevention.MustBeAfter;
import se.jiderhamn.classloader.leak.prevention.cleanup.StopThreadsCleanUp;

public class KeepAliveTimerCacheCleanUp
implements ClassLoaderPreMortemCleanUp,
MustBeAfter<ClassLoaderPreMortemCleanUp> {
    @Override
    public Class<? extends ClassLoaderPreMortemCleanUp>[] mustBeBeforeMe() {
        return new Class[]{StopThreadsCleanUp.class};
    }

    @Override
    public void cleanUp(ClassLoaderLeakPreventor preventor) {
        Thread keepAliveTimer;
        Object keepAliveCache = preventor.getStaticFieldValue("sun.net.www.http.HttpClient", "kac", true);
        if (keepAliveCache != null && (keepAliveTimer = (Thread)preventor.getFieldValue(keepAliveCache, "keepAliveTimer")) != null && preventor.isClassLoaderOrChild(keepAliveTimer.getContextClassLoader())) {
            keepAliveTimer.setContextClassLoader(preventor.getLeakSafeClassLoader());
            preventor.error("ContextClassLoader of sun.net.www.http.HttpClient cached Keep-Alive-Timer set to " + preventor.getLeakSafeClassLoader());
        }
    }
}

