/*
 * Decompiled with CFR 0.152.
 */
package se.jiderhamn.classloader.leak.prevention;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import se.jiderhamn.classloader.leak.prevention.ClassLoaderPreMortemCleanUp;
import se.jiderhamn.classloader.leak.prevention.Logger;
import se.jiderhamn.classloader.leak.prevention.PreClassLoaderInitiator;

public class ClassLoaderLeakPreventor {
    public static final int THREAD_WAIT_MS_DEFAULT = 5000;
    private static final ProtectionDomain[] NO_DOMAINS = new ProtectionDomain[0];
    private static final AccessControlContext NO_DOMAINS_ACCESS_CONTROL_CONTEXT = new AccessControlContext(NO_DOMAINS);
    private final Method java_lang_ClassLoader_isAncestor;
    private final Method java_lang_ClassLoader_isAncestorOf;
    private final Field java_security_AccessControlContext$combiner;
    private final Field java_security_AccessControlContext$parent;
    private final Field java_security_AccessControlContext$privilegedContext;
    private final ClassLoader leakSafeClassLoader;
    private final ClassLoader classLoader;
    private final Logger logger;
    private final Collection<PreClassLoaderInitiator> preClassLoaderInitiators;
    private final Collection<ClassLoaderPreMortemCleanUp> cleanUps;
    private final DomainCombiner domainCombiner;

    public ClassLoaderLeakPreventor(ClassLoader leakSafeClassLoader, ClassLoader classLoader, Logger logger, Collection<PreClassLoaderInitiator> preClassLoaderInitiators, Collection<ClassLoaderPreMortemCleanUp> cleanUps) {
        this.leakSafeClassLoader = leakSafeClassLoader;
        this.classLoader = classLoader;
        this.logger = logger;
        this.preClassLoaderInitiators = preClassLoaderInitiators;
        this.cleanUps = cleanUps;
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.startsWith("IBM")) {
            this.java_lang_ClassLoader_isAncestor = null;
            this.java_lang_ClassLoader_isAncestorOf = this.findMethod(ClassLoader.class, "isAncestorOf", ClassLoader.class);
        } else {
            this.java_lang_ClassLoader_isAncestor = this.findMethod(ClassLoader.class, "isAncestor", ClassLoader.class);
            this.java_lang_ClassLoader_isAncestorOf = null;
        }
        NestedProtectionDomainCombinerException.class.getName();
        this.domainCombiner = this.createDomainCombiner();
        this.java_security_AccessControlContext$combiner = this.findField(AccessControlContext.class, "combiner");
        this.java_security_AccessControlContext$parent = this.findField(AccessControlContext.class, "parent");
        this.java_security_AccessControlContext$privilegedContext = this.findField(AccessControlContext.class, "privilegedContext");
    }

    public void runPreClassLoaderInitiators() {
        this.info("Initializing by loading some known offenders with leak safe classloader");
        this.doInLeakSafeClassLoader(new Runnable(){

            @Override
            public void run() {
                for (PreClassLoaderInitiator preClassLoaderInitiator : ClassLoaderLeakPreventor.this.preClassLoaderInitiators) {
                    preClassLoaderInitiator.doOutsideClassLoader(ClassLoaderLeakPreventor.this);
                }
            }
        });
    }

    protected void doInLeakSafeClassLoader(final Runnable runnable) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.leakSafeClassLoader);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    runnable.run();
                    return null;
                }
            }, this.createAccessControlContext());
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public AccessControlContext createAccessControlContext() {
        try {
            return new AccessControlContext(NO_DOMAINS_ACCESS_CONTROL_CONTEXT, this.domainCombiner);
        }
        catch (SecurityException e) {
            try {
                Constructor constructor = AccessControlContext.class.getDeclaredConstructor(ProtectionDomain[].class, DomainCombiner.class);
                constructor.setAccessible(true);
                return (AccessControlContext)constructor.newInstance(NO_DOMAINS, this.domainCombiner);
            }
            catch (Exception e1) {
                this.logger.error("createAccessControlContext not granted and AccessControlContext could not be created via reflection");
                return AccessController.getContext();
            }
        }
    }

    private DomainCombiner createDomainCombiner() {
        return new DomainCombiner(){
            private final ThreadLocal<Boolean> isExecuting = new ThreadLocal();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ProtectionDomain[] combine(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
                if (assignedDomains != null && assignedDomains.length > 0) {
                    ClassLoaderLeakPreventor.this.logger.error("Unexpected assignedDomains - please report to developer of this library!");
                }
                if (this.isExecuting.get() == Boolean.TRUE) {
                    throw new NestedProtectionDomainCombinerException();
                }
                try {
                    this.isExecuting.set(Boolean.TRUE);
                    ArrayList<ProtectionDomain> output = new ArrayList<ProtectionDomain>();
                    for (ProtectionDomain protectionDomain : currentDomains) {
                        if (protectionDomain.getClassLoader() != null && ClassLoaderLeakPreventor.this.isClassLoaderOrChild(protectionDomain.getClassLoader())) continue;
                        output.add(protectionDomain);
                    }
                    ProtectionDomain[] protectionDomainArray = output.toArray(new ProtectionDomain[output.size()]);
                    return protectionDomainArray;
                }
                finally {
                    this.isExecuting.remove();
                }
            }
        };
    }

    @Deprecated
    public void removeDomainCombiner(Thread thread, AccessControlContext accessControlContext) {
        this.removeDomainCombiner("thread " + thread, accessControlContext);
    }

    public void removeDomainCombiner(String owner, AccessControlContext accessControlContext) {
        if (accessControlContext != null && this.java_security_AccessControlContext$combiner != null) {
            if (this.getFieldValue(this.java_security_AccessControlContext$combiner, accessControlContext) == this.domainCombiner) {
                this.warn(AccessControlContext.class.getSimpleName() + " of " + owner + " used custom combiner - unsetting");
                try {
                    this.java_security_AccessControlContext$combiner.set(accessControlContext, null);
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
            if (this.java_security_AccessControlContext$parent != null) {
                this.removeDomainCombiner(owner, (AccessControlContext)this.getFieldValue(this.java_security_AccessControlContext$parent, accessControlContext));
            }
            if (this.java_security_AccessControlContext$privilegedContext != null) {
                this.removeDomainCombiner(owner, (AccessControlContext)this.getFieldValue(this.java_security_AccessControlContext$privilegedContext, accessControlContext));
            }
        }
    }

    public void runCleanUps() {
        if (this.isJvmShuttingDown()) {
            this.info("JVM is shutting down - skip cleanup");
        } else {
            Field inheritedAccessControlContext = this.findField(Thread.class, "inheritedAccessControlContext");
            if (inheritedAccessControlContext != null) {
                for (Thread thread : this.getAllThreads()) {
                    AccessControlContext accessControlContext = (AccessControlContext)this.getFieldValue(inheritedAccessControlContext, thread);
                    this.removeDomainCombiner("thread " + thread, accessControlContext);
                }
            }
            for (ClassLoaderPreMortemCleanUp cleanUp : this.cleanUps) {
                cleanUp.cleanUp(this);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getLeakSafeClassLoader() {
        return this.leakSafeClassLoader;
    }

    public boolean isLoadedInClassLoader(Object o) {
        return o instanceof Class && this.isLoadedByClassLoader((Class)o) || o != null && this.isLoadedByClassLoader(o.getClass());
    }

    public boolean isLoadedByClassLoader(Class<?> clazz) {
        return clazz != null && this.isClassLoaderOrChild(clazz.getClassLoader());
    }

    public boolean isClassLoaderOrChild(ClassLoader cl) {
        if (cl == null) {
            return false;
        }
        if (cl == this.classLoader) {
            return true;
        }
        if (this.java_lang_ClassLoader_isAncestor != null) {
            try {
                return (Boolean)this.java_lang_ClassLoader_isAncestor.invoke((Object)cl, this.classLoader);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        if (this.java_lang_ClassLoader_isAncestorOf != null) {
            try {
                return (Boolean)this.java_lang_ClassLoader_isAncestorOf.invoke((Object)this.classLoader, cl);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        try {
            while (cl != null) {
                if (cl == this.classLoader) {
                    return true;
                }
                cl = cl.getParent();
            }
        }
        catch (NestedProtectionDomainCombinerException e) {
            return false;
        }
        return false;
    }

    public boolean isThreadInClassLoader(Thread thread) {
        return this.isLoadedInClassLoader(thread) || this.isLoadedInClassLoader(thread.getThreadGroup()) || this.isClassLoaderOrChild(thread.getContextClassLoader());
    }

    public void waitForThread(Thread thread, long waitMs, boolean interrupt) {
        if (waitMs > 0L) {
            if (interrupt) {
                try {
                    thread.interrupt();
                }
                catch (SecurityException e) {
                    this.error(e);
                }
            }
            try {
                thread.join(waitMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getStackTrace(Thread thread) {
        try {
            StackTraceElement[] stackTrace = thread.getStackTrace();
            if (stackTrace.length == 0) {
                return "Thread state: " + (Object)((Object)thread.getState());
            }
            StringBuilder output = new StringBuilder("Thread stack trace: ");
            for (StackTraceElement stackTraceElement : stackTrace) {
                output.append("\n\tat ");
                output.append(stackTraceElement.toString());
            }
            return output.toString().trim();
        }
        catch (Throwable t) {
            return "Thread details unavailable";
        }
    }

    public <E> E getStaticFieldValue(Class<?> clazz, String fieldName) {
        Field staticField = this.findField(clazz, fieldName);
        return staticField != null ? (E)this.getStaticFieldValue(staticField) : null;
    }

    public <E> E getStaticFieldValue(String className, String fieldName) {
        return this.getStaticFieldValue(className, fieldName, false);
    }

    public <E> E getStaticFieldValue(String className, String fieldName, boolean trySystemCL) {
        Field staticField = this.findFieldOfClass(className, fieldName, trySystemCL);
        return staticField != null ? (E)this.getStaticFieldValue(staticField) : null;
    }

    public Field findFieldOfClass(String className, String fieldName) {
        return this.findFieldOfClass(className, fieldName, false);
    }

    public Field findFieldOfClass(String className, String fieldName, boolean trySystemCL) {
        Class<?> clazz = this.findClass(className, trySystemCL);
        if (clazz != null) {
            return this.findField(clazz, fieldName);
        }
        return null;
    }

    public Class<?> findClass(String className) {
        return this.findClass(className, false);
    }

    public Class<?> findClass(String className, boolean trySystemCL) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (trySystemCL) {
                try {
                    return Class.forName(className, true, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    return null;
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    public Field findField(Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    public <T> T getStaticFieldValue(Field field) {
        try {
            if (!Modifier.isStatic(field.getModifiers())) {
                this.warn(field.toString() + " is not static");
                return null;
            }
            return (T)field.get(null);
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    public <T> T getFieldValue(Object obj, String fieldName) {
        Field field = this.findField(obj.getClass(), fieldName);
        return this.getFieldValue(field, obj);
    }

    public <T> T getFieldValue(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception ex) {
            this.warn(ex);
            return null;
        }
    }

    public void setFinalStaticField(Field field, Object newValue) {
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (NoSuchFieldException e) {
            this.warn("Unable to get 'modifiers' field of java.lang.Field");
        }
        catch (IllegalAccessException e) {
            this.warn("Unable to set 'modifiers' field of java.lang.Field");
        }
        catch (Throwable t) {
            this.warn(t);
        }
        try {
            field.set(null, newValue);
        }
        catch (Throwable e) {
            this.error("Error setting value of " + field + " to " + newValue);
        }
    }

    public Method findMethod(String className, String methodName, Class ... parameterTypes) {
        Class<?> clazz = this.findClass(className);
        if (clazz != null) {
            return this.findMethod(clazz, methodName, parameterTypes);
        }
        return null;
    }

    public Method findMethod(Class<?> clazz, String methodName, Class ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            this.warn(ex);
            return null;
        }
    }

    public Collection<Thread> getAllThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int guessThreadCount = tg.activeCount() + 50;
        Thread[] threads = new Thread[guessThreadCount];
        int actualThreadCount = tg.enumerate(threads);
        while (actualThreadCount == guessThreadCount) {
            threads = new Thread[guessThreadCount *= 2];
            actualThreadCount = tg.enumerate(threads);
        }
        ArrayList<Thread> output = new ArrayList<Thread>();
        for (Thread t : threads) {
            if (t == null) continue;
            output.add(t);
        }
        return output;
    }

    public boolean isJBoss() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            return contextClassLoader.getResource("org/jboss") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isOracleJRE() {
        String javaVendor = System.getProperty("java.vendor");
        return javaVendor.startsWith("Oracle") || javaVendor.startsWith("Sun");
    }

    public static void gc() {
        if (ClassLoaderLeakPreventor.isDisableExplicitGCEnabled()) {
            System.err.println(ClassLoaderLeakPreventor.class.getSimpleName() + ": Skipping GC call since -XX:+DisableExplicitGC is supplied as VM option.");
            return;
        }
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (ref.get() != null) {
            System.gc();
        }
    }

    private static boolean isDisableExplicitGCEnabled() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        List<String> aList = bean.getInputArguments();
        return aList.contains("-XX:+DisableExplicitGC");
    }

    public boolean isJvmShuttingDown() {
        try {
            Thread dummy = new Thread();
            Runtime.getRuntime().removeShutdownHook(dummy);
            return false;
        }
        catch (IllegalStateException isex) {
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void warn(Throwable t) {
        this.logger.warn(t);
    }

    public void error(Throwable t) {
        this.logger.error(t);
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void error(String msg) {
        this.logger.error(msg);
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    private static class NestedProtectionDomainCombinerException
    extends RuntimeException {
        private NestedProtectionDomainCombinerException() {
        }
    }
}

