/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;

public final class ViolationParserUtils {
    private ViolationParserUtils() {
    }

    public static String asString(XMLStreamReader xmlr) throws Exception {
        Transformer transformer = ViolationParserUtils.createTranformer();
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new StAXSource(xmlr), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static Optional<String> findAttribute(XMLStreamReader in, String attribute) {
        return Optional.ofNullable(in.getAttributeValue("", attribute));
    }

    public static Optional<Integer> findIntegerAttribute(XMLStreamReader in, String attribute) {
        String attr = in.getAttributeValue("", attribute);
        if (attr == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Integer.parseInt(attr));
    }

    public static String getAttribute(XMLStreamReader in, String attribute) {
        String foundOpt = in.getAttributeValue("", attribute);
        if (foundOpt == null) {
            String foundin;
            try {
                foundin = ViolationParserUtils.asString(in);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("\"" + attribute + "\" not found in:\n" + foundin);
        }
        return foundOpt;
    }

    public static Integer getIntegerAttribute(XMLStreamReader in, String attribute) {
        return Integer.parseInt(ViolationParserUtils.getAttribute(in, attribute));
    }

    public static List<String> getLines(String string) {
        return Arrays.asList(string.split("\n"));
    }

    public static List<List<String>> getLines(String string, String regexpPerLine) {
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        Pattern pattern = Pattern.compile(regexpPerLine);
        for (String line : string.split("\n")) {
            List<String> found = ViolationParserUtils.getLineParts(pattern, line);
            if (found == null) continue;
            results.add(found);
        }
        return results;
    }

    public static List<String> getLineParts(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<String> lineParts = new ArrayList<String>();
        for (int g = 0; g <= matcher.groupCount(); ++g) {
            lineParts.add(matcher.group(g));
        }
        return lineParts;
    }

    public static List<String> getParts(String string, String ... regexpList) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String regexp : regexpList) {
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(string);
            boolean found = matcher.find();
            if (!found) {
                return new ArrayList<String>();
            }
            String part = matcher.group(1).trim();
            parts.add(part);
            string = string.replaceFirst(Pattern.quote(matcher.group()), "").trim();
        }
        return parts;
    }

    private static Transformer createTranformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }

    public static XMLStreamReader createXmlReader(InputStream input) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xmlr = factory.createXMLStreamReader(input);
        return xmlr;
    }
}

