/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class KotlinMavenParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(string, "\\[(ERROR|WARNING)\\]([^:]*)[^\\d]+?(\\d+?)[^\\d]+?(\\d+?)[^\\)]+?\\)(.*)");
        for (List<String> parts : partsPerLine) {
            String severity = parts.get(1).trim();
            String filename = parts.get(2).trim();
            Integer line = Integer.parseInt(parts.get(3));
            Integer column = Integer.parseInt(parts.get(4));
            String message = parts.get(5).trim();
            violations.add(Violation.violationBuilder().setParser(Parser.KOTLINMAVEN).setStartLine(line).setColumn(column).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

