/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class FindbugsParser
implements ViolationsParser {
    public static final String FINDBUGS_SPECIFIC_RANK = "RANK";
    private static String findbugsMessagesXml;
    private static String findSecurityBugsMessagesXml;

    public static void setFindbugsMessagesXml(String findbugsMessagesXml) {
        FindbugsParser.findbugsMessagesXml = findbugsMessagesXml;
    }

    public static void setFindSecurityBugsMessagesXml(String findSecurityBugsMessagesXml) {
        FindbugsParser.findSecurityBugsMessagesXml = findSecurityBugsMessagesXml;
    }

    private Map<String, String> getMessagesPerType(ViolationsLogger violationsLogger, String messagesXml) throws Exception {
        HashMap<String, String> messagesPerType = new HashMap<String, String>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(messagesXml.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String type = "";
            String shortDescription = "";
            String details = "";
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType == 1) {
                    if (xmlr.getLocalName().equalsIgnoreCase("BugPattern")) {
                        type = ViolationParserUtils.getAttribute(xmlr, "type");
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("ShortDescription")) {
                        shortDescription = xmlr.getElementText();
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("Details")) {
                        details = xmlr.getElementText();
                    }
                }
                if (eventType != 2 || !xmlr.getLocalName().equalsIgnoreCase("BugPattern")) continue;
                messagesPerType.put(type, shortDescription + "\n\n" + details);
            }
        }
        catch (IOException e) {
            violationsLogger.log(Level.SEVERE, e.getMessage(), e);
        }
        return messagesPerType;
    }

    private void parseBugInstance(XMLStreamReader xmlr, Set<Violation> violations, Map<String, String> messagesPerType) throws XMLStreamException {
        String type = ViolationParserUtils.getAttribute(xmlr, "type");
        Integer rank = ViolationParserUtils.getIntegerAttribute(xmlr, "rank");
        String message = messagesPerType.get(type);
        if (message == null) {
            message = type;
        }
        SEVERITY severity = this.toSeverity(rank);
        ArrayList<Violation> candidates = new ArrayList<Violation>();
        while (xmlr.hasNext()) {
            int eventType = xmlr.next();
            if (eventType == 1 && xmlr.getLocalName().equalsIgnoreCase("SourceLine")) {
                Optional<Integer> startLine = ViolationParserUtils.findIntegerAttribute(xmlr, "start");
                Optional<Integer> endLine = ViolationParserUtils.findIntegerAttribute(xmlr, "end");
                if (!startLine.isPresent() || !endLine.isPresent()) continue;
                String filename = ViolationParserUtils.getAttribute(xmlr, "sourcepath");
                String classname = ViolationParserUtils.getAttribute(xmlr, "classname");
                candidates.add(Violation.violationBuilder().setParser(Parser.FINDBUGS).setMessage(message).setFile(filename).setStartLine(startLine.get()).setEndLine(endLine.get()).setRule(type).setSeverity(severity).setSource(classname).setSpecific(FINDBUGS_SPECIFIC_RANK, rank).build());
            }
            if (eventType != 2 || !xmlr.getLocalName().equalsIgnoreCase("BugInstance")) continue;
            break;
        }
        if (!candidates.isEmpty()) {
            violations.add((Violation)candidates.get(candidates.size() - 1));
        }
    }

    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        Map<String, String> messagesPerType = this.getMessagesPerType(violationsLogger, this.getMessagesXml(findbugsMessagesXml, "/findbugs/messages.xml"));
        messagesPerType.putAll(this.getMessagesPerType(violationsLogger, this.getMessagesXml(findSecurityBugsMessagesXml, "/findbugs/fsb-messages.xml")));
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1 || !xmlr.getLocalName().equalsIgnoreCase("BugInstance")) continue;
                this.parseBugInstance(xmlr, violations, messagesPerType);
            }
        }
        return violations;
    }

    private String getMessagesXml(String staticValue, String messagesResourceFilename) throws IOException {
        String messagesXml;
        if (Utils.isNullOrEmpty(staticValue)) {
            URL resource = FindbugsParser.class.getResource(messagesResourceFilename);
            if (resource == null) {
                throw new RuntimeException("Unable to find resource " + messagesResourceFilename);
            }
            messagesXml = Utils.toString(resource);
        } else {
            messagesXml = staticValue;
        }
        return messagesXml;
    }

    private SEVERITY toSeverity(Integer rank) {
        if (rank <= 9) {
            return SEVERITY.ERROR;
        }
        if (rank <= 14) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

