/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util;

public class Stats {
    private int n = 0;
    private double avg = 0.0;
    private double min = 0.0;
    private double max = 0.0;
    private double sum = 0.0;

    public void add(double x) {
        ++this.n;
        this.min = this.n == 1 ? x : Math.min(this.min, x);
        this.max = this.n == 1 ? x : Math.max(this.max, x);
        double d = x - this.avg;
        this.avg += d / (double)this.n;
        this.sum += d * d * (double)(this.n - 1) / (double)this.n;
    }

    public int count() {
        return this.n;
    }

    public double min() {
        if (this.n < 1) {
            return Double.NaN;
        }
        return this.min;
    }

    public double max() {
        if (this.n < 1) {
            return Double.NaN;
        }
        return this.max;
    }

    public double avg() {
        if (this.n < 1) {
            return Double.NaN;
        }
        return this.avg;
    }

    public double var() {
        if (this.n < 2) {
            return Double.NaN;
        }
        return this.sum / (double)(this.n - 1);
    }

    public double stddev() {
        return Math.sqrt(this.var());
    }
}

