/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib;

import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.StringUtils;

class ConfigLine {
    String prefix;
    String section;
    String subsection;
    String name;
    String value;
    String suffix;
    String includedFrom;

    ConfigLine() {
    }

    ConfigLine forValue(String newValue) {
        ConfigLine e = new ConfigLine();
        e.prefix = this.prefix;
        e.section = this.section;
        e.subsection = this.subsection;
        e.name = this.name;
        e.value = newValue;
        e.suffix = this.suffix;
        e.includedFrom = this.includedFrom;
        return e;
    }

    boolean match(String aSection, String aSubsection, String aKey) {
        return ConfigLine.eqIgnoreCase(this.section, aSection) && ConfigLine.eqSameCase(this.subsection, aSubsection) && ConfigLine.eqIgnoreCase(this.name, aKey);
    }

    boolean match(String aSection, String aSubsection) {
        return ConfigLine.eqIgnoreCase(this.section, aSection) && ConfigLine.eqSameCase(this.subsection, aSubsection);
    }

    private static boolean eqIgnoreCase(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(a, b);
    }

    private static boolean eqSameCase(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toString() {
        if (this.section == null) {
            return "<empty>";
        }
        StringBuilder b = new StringBuilder(this.section);
        if (this.subsection != null) {
            b.append(".").append(this.subsection);
        }
        if (this.name != null) {
            b.append(".").append(this.name);
        }
        if (this.value != null) {
            b.append("=").append(this.value);
        }
        return b.toString();
    }
}

