/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.generated.sarif.Artifact;
import se.bjurr.violations.lib.model.generated.sarif.Invocation;
import se.bjurr.violations.lib.model.generated.sarif.Location;
import se.bjurr.violations.lib.model.generated.sarif.Message;
import se.bjurr.violations.lib.model.generated.sarif.MessageStrings;
import se.bjurr.violations.lib.model.generated.sarif.MultiformatMessageString;
import se.bjurr.violations.lib.model.generated.sarif.Notification;
import se.bjurr.violations.lib.model.generated.sarif.PhysicalLocation;
import se.bjurr.violations.lib.model.generated.sarif.PropertyBag;
import se.bjurr.violations.lib.model.generated.sarif.Region;
import se.bjurr.violations.lib.model.generated.sarif.ReportingConfiguration;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptor;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptorReference;
import se.bjurr.violations.lib.model.generated.sarif.Result;
import se.bjurr.violations.lib.model.generated.sarif.Run;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;
import se.bjurr.violations.lib.model.generated.sarif.Suppression;
import se.bjurr.violations.lib.model.generated.sarif.ToolComponent;
import se.bjurr.violations.lib.model.generated.sarif.ToolComponentReference;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.violationslib.com.google.gson.GsonBuilder;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializationContext;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializer;
import se.bjurr.violations.violationslib.com.google.gson.JsonElement;
import se.bjurr.violations.violationslib.com.google.gson.JsonParseException;

public class SarifParser
implements ViolationsParser {
    public static final String SARIF_RESULTS_CORRELATION_GUID = "correlationGuid";
    public static final String SARIF_RESULTS_SUPPRESSED = "suppressed";

    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        SarifSchema report = new GsonBuilder().registerTypeAdapter((Type)((Object)Result.Level.class), new ResultDeserializer()).registerTypeAdapter((Type)((Object)Notification.Level.class), new NotificationDeserializer()).registerTypeAdapter((Type)((Object)ReportingConfiguration.Level.class), new ReportingConfigurationDeserializer()).registerTypeAdapter((Type)((Object)MessageStrings.class), new MessageStringsDeserializer()).create().fromJson(reportContent, SarifSchema.class);
        TreeSet<Violation> violations = new TreeSet<Violation>();
        if (report.getRuns() == null) {
            return violations;
        }
        for (Run run : report.getRuns()) {
            violations.addAll(this.parseNotifications(run));
            violations.addAll(this.parseResults(run));
        }
        return violations;
    }

    private Set<Violation> parseResults(Run run) {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (Result result : run.getResults()) {
            String ruleId = result.getRuleId();
            Message message = result.getMessage();
            if (message == null) continue;
            Result.Level level = result.getLevel();
            HashMap<String, String> specifics = new HashMap<String, String>();
            String correlationGuid = result.getCorrelationGuid();
            if (!Utils.isNullOrEmpty(correlationGuid)) {
                specifics.put(SARIF_RESULTS_CORRELATION_GUID, correlationGuid);
            }
            specifics.put(SARIF_RESULTS_SUPPRESSED, this.isSuppressed(result) ? "true" : "false");
            ReportingDescriptor reportingDescriptor = this.findReportingDescriptor(run, result, DescriptorElementOf.RULES).orElse(null);
            String category = this.getCategory(reportingDescriptor);
            String reporter = this.getReporter(run, result.getRule());
            Optional<String> helpTextOpt = this.findHelpText(reportingDescriptor);
            List<Location> locations = this.filterLocations(result.getLocations());
            if (this.notEmptyOrNull(locations)) {
                for (Location location : locations) {
                    ParsedPhysicalLocation parsedPhysicalLocation = this.parsePhysicalLocation(location.getPhysicalLocation(), run.getArtifacts());
                    String fullMessage = this.toMessage(message, helpTextOpt, parsedPhysicalLocation, reportingDescriptor);
                    violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile(parsedPhysicalLocation.filename).setStartLine(parsedPhysicalLocation.startLine).setRule(ruleId).setMessage(fullMessage).setSeverity(this.toSeverity(level, reportingDescriptor)).setReporter(reporter).setCategory(category).setSpecifics(specifics).build());
                }
                continue;
            }
            String fullMessage = this.toMessage(message, helpTextOpt, reportingDescriptor);
            violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile("-").setStartLine(Violation.NO_LINE).setRule(ruleId).setMessage(fullMessage).setSeverity(this.toSeverity(level, reportingDescriptor)).setReporter(reporter).setCategory(category).setSpecifics(specifics).build());
        }
        return violations;
    }

    private Set<Violation> parseNotifications(Run run) {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (Invocation invocation : run.getInvocations()) {
            for (Notification notification : invocation.getToolConfigurationNotifications()) {
                ReportingDescriptorReference ref = notification.getAssociatedRule();
                Integer ruleIndex = this.getRuleIndex(ref);
                String ruleId = null;
                ReportingDescriptor reportingDescriptor = this.findReportingDescriptor(run, DescriptorElementOf.NOTIFICATIONS, ref, ruleIndex, ruleId).orElse(null);
                String reporter = this.getReporter(run, ref);
                String reportingDescriptorName = this.getName(reportingDescriptor);
                SEVERITY severity = this.toSeverity(notification.getLevel(), reportingDescriptor);
                List<Location> locations = this.filter(notification.getLocations());
                if (this.notEmptyOrNull(locations)) {
                    for (Location location : locations) {
                        ParsedPhysicalLocation parsedPhysicalLocation = this.parsePhysicalLocation(location.getPhysicalLocation(), run.getArtifacts());
                        Optional<String> helpTextOpt = Optional.empty();
                        String fullMessage = this.toMessage(notification.getMessage(), helpTextOpt, parsedPhysicalLocation, reportingDescriptor);
                        violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile(parsedPhysicalLocation.filename).setStartLine(parsedPhysicalLocation.startLine).setRule(reportingDescriptorName).setMessage(fullMessage).setSeverity(severity).setReporter(reporter).build());
                    }
                    continue;
                }
                String message = this.extractMessage(notification.getMessage(), reportingDescriptor);
                if (message.isEmpty()) continue;
                violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile("-").setStartLine(Violation.NO_LINE).setRule(reportingDescriptorName).setMessage(message).setSeverity(severity).setReporter(reporter).build());
            }
        }
        return violations;
    }

    private boolean isSuppressed(Result result) {
        List supressions = result.getSuppressions().stream().filter((? super T it) -> it.getState() != Suppression.State.UNDER_REVIEW && it.getState() != Suppression.State.REJECTED).collect(Collectors.toList());
        return !supressions.isEmpty();
    }

    private String getReporter(Run run, ReportingDescriptorReference ref) {
        ToolComponent tool = this.findToolComponent(run, ref);
        if (tool != null && tool.getName() != null && !tool.getName().trim().isEmpty()) {
            return tool.getName();
        }
        return "Sarif";
    }

    private Integer getRuleIndex(ReportingDescriptorReference ref) {
        Integer ruleIndex = null;
        if (ref != null) {
            ruleIndex = ref.getIndex();
        }
        if (ruleIndex == null || ruleIndex == -1) {
            return null;
        }
        return ruleIndex;
    }

    private String getName(ReportingDescriptor reportingDescriptor) {
        if (reportingDescriptor != null) {
            return reportingDescriptor.getName();
        }
        return null;
    }

    private String getCategory(ReportingDescriptor reportingDescriptor) {
        PropertyBag properties;
        if (reportingDescriptor != null && (properties = reportingDescriptor.getProperties()) != null && properties.getCategory() != null) {
            return properties.getCategory();
        }
        return null;
    }

    private boolean notEmptyOrNull(List<Location> locations) {
        return locations != null && locations.size() > 0;
    }

    private List<Location> filter(Set<Location> locations) {
        return this.filterLocations(new ArrayList<Location>(locations));
    }

    private List<Location> filterLocations(List<Location> locations) {
        if (locations == null) {
            return new ArrayList<Location>();
        }
        return locations.stream().filter((? super T it) -> it.getPhysicalLocation() != null && it.getPhysicalLocation().getRegion() != null && it.getPhysicalLocation().getRegion().getStartLine() != null).collect(Collectors.toList());
    }

    private String toMessage(Message message, Optional<String> helpTextOpt, ParsedPhysicalLocation parsedPhysicalLocation, ReportingDescriptor reportingDescriptor) {
        StringBuilder fullMessage = new StringBuilder(this.extractMessage(message, reportingDescriptor));
        if (!Utils.isNullOrEmpty(parsedPhysicalLocation.regionMessage)) {
            fullMessage.append("\n\n").append(parsedPhysicalLocation.regionMessage);
        }
        if (helpTextOpt.isPresent()) {
            fullMessage.append("\n\nFor additional help see: ").append(helpTextOpt.get());
        }
        return fullMessage.toString().trim();
    }

    private String toMessage(Message message, Optional<String> helpTextOpt, ReportingDescriptor reportingDescriptor) {
        String messageText;
        StringBuilder fullMessage = new StringBuilder();
        if (reportingDescriptor != null && reportingDescriptor.getId() != null) {
            fullMessage.append(reportingDescriptor.getId());
        }
        if (reportingDescriptor != null && reportingDescriptor.getName() != null && !Utils.isNullOrEmpty(reportingDescriptor.getName())) {
            fullMessage.append(": ").append(reportingDescriptor.getName());
        }
        if (reportingDescriptor != null && reportingDescriptor.getShortDescription() != null && !Utils.isNullOrEmpty(reportingDescriptor.getShortDescription().getMarkdown())) {
            fullMessage.append("\n\n").append(reportingDescriptor.getShortDescription().getMarkdown());
        } else if (reportingDescriptor != null && reportingDescriptor.getShortDescription() != null && !Utils.isNullOrEmpty(reportingDescriptor.getShortDescription().getText())) {
            fullMessage.append("\n\n").append(reportingDescriptor.getShortDescription().getText());
        }
        if (helpTextOpt.isPresent()) {
            fullMessage.append("\n\nFor additional help see: ").append(helpTextOpt.get());
        }
        if (fullMessage.indexOf(messageText = this.extractMessage(message, null)) < 0) {
            fullMessage.append("\n\n").append(messageText);
        }
        return fullMessage.toString();
    }

    private ParsedPhysicalLocation parsePhysicalLocation(PhysicalLocation physicalLocation, Set<Artifact> artifacts) {
        ParsedPhysicalLocation parsed = new ParsedPhysicalLocation();
        Region region = physicalLocation.getRegion();
        if (region == null) {
            return parsed;
        }
        parsed.startLine = Optional.ofNullable(region.getStartLine()).orElse(Violation.NO_LINE);
        parsed.regionMessage = this.extractMessage(region.getMessage(), null);
        Integer artifactLocationIndex = physicalLocation.getArtifactLocation().getIndex();
        parsed.filename = artifactLocationIndex != null && artifactLocationIndex != -1 ? new ArrayList<Artifact>(artifacts).get(artifactLocationIndex).getLocation().getUri() : physicalLocation.getArtifactLocation().getUri();
        return parsed;
    }

    private String extractMessage(Message message, ReportingDescriptor reportingDescriptor) {
        if (message == null) {
            return "";
        }
        String text = message.getMarkdown();
        if (Utils.isNullOrEmpty(text)) {
            text = message.getText();
        }
        if (!Utils.isNullOrEmpty(text)) {
            return text;
        }
        if (message.getId() != null && reportingDescriptor != null && reportingDescriptor.getMessageStrings() != null) {
            String messageText = reportingDescriptor.getMessageStrings().getAdditionalProperties().get(message.getId()).getText();
            List<String> arguments = message.getArguments();
            return this.renderString(messageText, arguments);
        }
        if (reportingDescriptor != null && reportingDescriptor.getShortDescription() != null) {
            return reportingDescriptor.getShortDescription().toString();
        }
        return "";
    }

    private String renderString(String text, List<String> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            text = text.replace("{" + i + "}", arguments.get(i));
        }
        return text;
    }

    private Optional<String> findHelpText(ReportingDescriptor r) {
        if (r == null) {
            return Optional.empty();
        }
        if (r.getHelp() != null && !Utils.isNullOrEmpty(r.getHelp().getMarkdown())) {
            return Optional.ofNullable(r.getHelp().getMarkdown());
        }
        if (r.getHelp() != null && !Utils.isNullOrEmpty(r.getHelp().getText())) {
            return Optional.ofNullable(r.getHelp().getText());
        }
        if (r.getFullDescription() != null && !Utils.isNullOrEmpty(r.getFullDescription().getMarkdown())) {
            return Optional.ofNullable(r.getFullDescription().getMarkdown());
        }
        if (r.getFullDescription() != null && !Utils.isNullOrEmpty(r.getFullDescription().getText())) {
            return Optional.ofNullable(r.getFullDescription().getText());
        }
        return Optional.ofNullable(r.getName());
    }

    private SEVERITY toSeverity(Notification.Level level, ReportingDescriptor reportingDescriptor) {
        if (level == null) {
            return this.toSeverity(reportingDescriptor).orElse(SEVERITY.INFO);
        }
        if (level == Notification.Level.ERROR) {
            return SEVERITY.ERROR;
        }
        if (level == Notification.Level.WARNING) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private SEVERITY toSeverity(Result.Level level, ReportingDescriptor reportingDescriptor) {
        if (level == null) {
            return this.toSeverity(reportingDescriptor).orElse(SEVERITY.INFO);
        }
        if (level == Result.Level.ERROR) {
            return SEVERITY.ERROR;
        }
        if (level == Result.Level.WARNING) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private Optional<SEVERITY> toSeverity(ReportingDescriptor reportingDescriptor) {
        if (reportingDescriptor != null && reportingDescriptor.getDefaultConfiguration() != null && reportingDescriptor.getDefaultConfiguration().getLevel() != null) {
            ReportingConfiguration.Level level = reportingDescriptor.getDefaultConfiguration().getLevel();
            if (level == ReportingConfiguration.Level.ERROR) {
                return Optional.of(SEVERITY.ERROR);
            }
            if (level == ReportingConfiguration.Level.WARNING) {
                return Optional.of(SEVERITY.WARN);
            }
        }
        return Optional.empty();
    }

    private Optional<ReportingDescriptor> findReportingDescriptor(Run run, Result result, DescriptorElementOf lookIn) {
        ReportingDescriptorReference ref = result.getRule();
        Integer ruleIndex = this.findRuleIndex(result, ref);
        String ruleId = result.getRuleId();
        return this.findReportingDescriptor(run, lookIn, ref, ruleIndex, ruleId);
    }

    private Optional<ReportingDescriptor> findReportingDescriptor(Run run, DescriptorElementOf lookIn, ReportingDescriptorReference ref, Integer ruleIndex, String ruleId) {
        ToolComponent tool = this.findToolComponent(run, ref);
        if (tool == null) {
            return Optional.empty();
        }
        if (ruleIndex != null) {
            return Optional.of(this.getReportingDescriptorByIndex(tool, ruleIndex, lookIn));
        }
        if (ref != null && ref.getGuid() != null) {
            return this.findReportingDescriptorByGui(tool, ref.getGuid(), lookIn);
        }
        if (ruleId != null) {
            return this.findReportingDescriptorByRuleId(tool, ruleId, lookIn);
        }
        return Optional.empty();
    }

    private Integer findRuleIndex(Result result, ReportingDescriptorReference ref) {
        Integer ruleIndex = result.getRuleIndex();
        if (ruleIndex == -1) {
            ruleIndex = null;
        }
        if (ruleIndex == null && ref != null) {
            ruleIndex = ref.getIndex();
        }
        return ruleIndex;
    }

    private ToolComponent findToolComponent(Run run, ReportingDescriptorReference ref) {
        if (run.getTool() == null) {
            return null;
        }
        if (ref == null) {
            return run.getTool().getDriver();
        }
        ToolComponentReference toolRef = ref.getToolComponent();
        if (toolRef.getGuid() != null) {
            return this.getToolComponentByGui(run, toolRef.getGuid());
        }
        if (toolRef.getIndex() != null) {
            return this.getToolComponentByIndex(run, toolRef.getIndex());
        }
        return run.getTool().getDriver();
    }

    private ReportingDescriptor getReportingDescriptorByIndex(ToolComponent tool, Integer index, DescriptorElementOf lookIn) {
        if (lookIn == DescriptorElementOf.RULES) {
            return new ArrayList<ReportingDescriptor>(tool.getRules()).get(index);
        }
        if (lookIn == DescriptorElementOf.NOTIFICATIONS) {
            return new ArrayList<ReportingDescriptor>(tool.getNotifications()).get(index);
        }
        throw new IllegalStateException((Object)((Object)lookIn) + " cannot find ReportingDescriptor");
    }

    private Optional<ReportingDescriptor> findReportingDescriptorByGui(ToolComponent tool, String guid, DescriptorElementOf lookIn) {
        if (lookIn == DescriptorElementOf.RULES) {
            return tool.getRules().stream().filter((? super T it) -> it.getGuid() != null && it.getGuid().equals(guid)).findFirst();
        }
        if (lookIn == DescriptorElementOf.NOTIFICATIONS) {
            return tool.getNotifications().stream().filter((? super T it) -> it.getGuid() != null && it.getGuid().equals(guid)).findFirst();
        }
        return Optional.empty();
    }

    private Optional<ReportingDescriptor> findReportingDescriptorByRuleId(ToolComponent tool, String ruleId, DescriptorElementOf lookIn) {
        if (lookIn == DescriptorElementOf.RULES) {
            return tool.getRules().stream().filter((? super T it) -> it.getId() != null && it.getId().equals(ruleId)).findFirst();
        }
        if (lookIn == DescriptorElementOf.NOTIFICATIONS) {
            return tool.getNotifications().stream().filter((? super T it) -> it.getId() != null && it.getId().equals(ruleId)).findFirst();
        }
        throw new IllegalStateException((Object)((Object)lookIn) + " cannot find ReportingDescriptor");
    }

    private ToolComponent getToolComponentByIndex(Run run, Integer index) {
        return new ArrayList<ToolComponent>(run.getTool().getExtensions()).get(index);
    }

    private ToolComponent getToolComponentByGui(Run run, String guid) {
        return run.getTool().getExtensions().stream().filter((? super T it) -> it.getGuid() != null && it.getGuid().equals(guid)).findFirst().get();
    }

    private static class MessageStringsDeserializer
    implements JsonDeserializer<MessageStrings> {
        private MessageStringsDeserializer() {
        }

        @Override
        public MessageStrings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                MessageStrings messageStrings = new MessageStrings();
                for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
                    for (Map.Entry<String, JsonElement> valueEntry : entry.getValue().getAsJsonObject().entrySet()) {
                        MultiformatMessageString mv = new MultiformatMessageString();
                        mv.setText(valueEntry.getValue().getAsString());
                        messageStrings.getAdditionalProperties().put(entry.getKey(), mv);
                    }
                }
                return messageStrings;
            }
            catch (RuntimeException e) {
                return new MessageStrings();
            }
        }
    }

    private static class ReportingConfigurationDeserializer
    implements JsonDeserializer<ReportingConfiguration.Level> {
        private ReportingConfigurationDeserializer() {
        }

        @Override
        public ReportingConfiguration.Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String asString = json.getAsString();
                return ReportingConfiguration.Level.fromValue(asString);
            }
            catch (Exception e) {
                return ReportingConfiguration.Level.NONE;
            }
        }
    }

    private static class NotificationDeserializer
    implements JsonDeserializer<Notification.Level> {
        private NotificationDeserializer() {
        }

        @Override
        public Notification.Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String asString = json.getAsString();
                return Notification.Level.fromValue(asString);
            }
            catch (Exception e) {
                return Notification.Level.NONE;
            }
        }
    }

    private static class ResultDeserializer
    implements JsonDeserializer<Result.Level> {
        private ResultDeserializer() {
        }

        @Override
        public Result.Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                String asString = json.getAsString();
                return Result.Level.fromValue(asString);
            }
            catch (Exception e) {
                return Result.Level.NONE;
            }
        }
    }

    private static class ParsedPhysicalLocation {
        public String regionMessage = null;
        public String filename = "-";
        public Integer startLine = Violation.NO_LINE;
    }

    private static enum DescriptorElementOf {
        RULES,
        NOTIFICATIONS;

    }
}

