/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PyLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(string, "([^:]*):(\\d+): \\[(\\D)(\\d*)\\(([^\\]]*)\\), ([^\\]]*)] (.*)");
        for (List<String> parts : partsPerLine) {
            String filename = parts.get(1);
            Integer line = Integer.parseInt(parts.get(2));
            String severity = parts.get(3);
            String ruleCode = parts.get(4);
            String rule = parts.get(5);
            String method = parts.get(6);
            String message = parts.get(7);
            violations.add(Violation.violationBuilder().setParser(Parser.PYLINT).setStartLine(line).setFile(filename).setRule(severity + ruleCode + "(" + rule + ")").setSeverity(this.toSeverity(severity)).setMessage(message).setSpecific("method", method).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("E") || severity.equalsIgnoreCase("F")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("W")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

