/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CheckStyleParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String content, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String filename = null;
            Integer line = null;
            Optional<Integer> column = null;
            String severity = null;
            String message = null;
            String rule = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType == 1) {
                    if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                        filename = ViolationParserUtils.getAttribute(xmlr, "name");
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("error")) {
                        line = ViolationParserUtils.findIntegerAttribute(xmlr, "line").orElse(0);
                        column = ViolationParserUtils.findIntegerAttribute(xmlr, "column");
                        severity = ViolationParserUtils.getAttribute(xmlr, "severity");
                        message = ViolationParserUtils.getAttribute(xmlr, "message");
                        rule = ViolationParserUtils.findAttribute(xmlr, "source").orElse(null);
                    }
                }
                if (eventType != 2 || !xmlr.getLocalName().equalsIgnoreCase("error")) continue;
                Violation violation = Violation.violationBuilder().setParser(Parser.CHECKSTYLE).setStartLine(line).setColumn(column.orElse(null)).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).setRule(rule).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

