/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class AndroidLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String content, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String severity = null;
            String id = null;
            String message = null;
            String summary = null;
            String explanation = null;
            String category = null;
            String filename = null;
            Optional<Integer> line = null;
            Optional<Integer> charAttrib = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType == 1) {
                    if (xmlr.getLocalName().equalsIgnoreCase("issue")) {
                        severity = ViolationParserUtils.getAttribute(xmlr, "severity");
                        id = ViolationParserUtils.getAttribute(xmlr, "id");
                        message = ViolationParserUtils.getAttribute(xmlr, "message");
                        summary = ViolationParserUtils.getAttribute(xmlr, "summary").trim();
                        explanation = ViolationParserUtils.getAttribute(xmlr, "explanation");
                        category = ViolationParserUtils.getAttribute(xmlr, "category");
                    }
                    if (xmlr.getLocalName().equalsIgnoreCase("location")) {
                        filename = ViolationParserUtils.getAttribute(xmlr, "file");
                        line = ViolationParserUtils.findIntegerAttribute(xmlr, "line");
                        charAttrib = ViolationParserUtils.findIntegerAttribute(xmlr, "column");
                    }
                }
                if (eventType != 2 || !xmlr.getLocalName().equalsIgnoreCase("issue")) continue;
                Violation violation = Violation.violationBuilder().setParser(Parser.ANDROIDLINT).setStartLine(line.orElse(0)).setColumn(charAttrib.orElse(null)).setFile(filename).setSeverity(this.toSeverity(severity)).setRule(id).setCategory(category).setMessage(summary + "\n" + message + "\n" + explanation).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR") || severity.equalsIgnoreCase("FATAL")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

