/*
 * Decompiled with CFR 0.152.
 */
package shadow.de.vandermeer.skb.interfaces.transformers;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import shadow.de.vandermeer.skb.interfaces.strategies.IsCollectionStrategy;
import shadow.de.vandermeer.skb.interfaces.transformers.Transformer;

public interface ClusterElementTransformer {
    default public <T1, T2, T3 extends T1, S extends Collection<T2>> S transform(Iterable<T3> input, Transformer<T1, T2> transformer, IsCollectionStrategy<S, T2> strategy) {
        return this.transform(input, transformer, null, strategy);
    }

    default public <T1, T2, T3 extends T1, S extends Collection<T2>> S transform(Iterable<T3> input, Transformer<T1, T2> transformer, Predicate<T3> predicate, IsCollectionStrategy<S, T2> strategy) {
        Validate.notNull(input);
        Validate.notNull(transformer);
        Validate.notNull(strategy);
        S ret = strategy.get();
        for (T3 t3 : input) {
            if (predicate != null && predicate.test(t3)) {
                ret.add(transformer.transform(t3));
                continue;
            }
            if (predicate != null) continue;
            ret.add(transformer.transform(t3));
        }
        return ret;
    }

    default public <T1, T2, T3 extends T1, S extends Collection<T2>> S transform(Iterator<T3> input, Transformer<T1, T2> transformer, IsCollectionStrategy<S, T2> strategy) {
        return this.transform(input, transformer, null, strategy);
    }

    default public <T1, T2, T3 extends T1, S extends Collection<T2>> S transform(Iterator<T3> input, Transformer<T1, T2> transformer, Predicate<T3> predicate, IsCollectionStrategy<S, T2> strategy) {
        Validate.notNull(input);
        Validate.notNull(transformer);
        Validate.notNull(strategy);
        S ret = strategy.get();
        while (input.hasNext()) {
            T3 t3 = input.next();
            if (predicate != null && predicate.test(t3)) {
                ret.add(transformer.transform(t3));
                continue;
            }
            if (predicate != null) continue;
            ret.add(transformer.transform(t3));
        }
        return ret;
    }

    default public <T1, T2, T3 extends T1, S extends Collection<T2>> S transform(T3[] input, Transformer<T1, T2> transformer, IsCollectionStrategy<S, T2> strategy) {
        return this.transform(input, transformer, null, strategy);
    }

    default public <T1, T2, T3 extends T1, S extends Collection<T2>> S transform(T3[] input, Transformer<T1, T2> transformer, Predicate<T3> predicate, IsCollectionStrategy<S, T2> strategy) {
        Validate.notNull(input);
        Validate.notNull(transformer);
        Validate.notNull(strategy);
        S ret = strategy.get();
        for (T3 t3 : input) {
            if (predicate != null && predicate.test(t3)) {
                ret.add(transformer.transform(t3));
                continue;
            }
            if (predicate != null) continue;
            ret.add(transformer.transform(t3));
        }
        return ret;
    }

    public static ClusterElementTransformer create() {
        return new ClusterElementTransformer(){};
    }
}

