/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.text.MessageFormat;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.StopWalkException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.TreeWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeFilterMarker {
    private final TreeFilter[] filters;

    public TreeFilterMarker(TreeFilter[] markTreeFilters) {
        if (markTreeFilters.length > 32) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().treeFilterMarkerTooManyFilters, 32, markTreeFilters.length));
        }
        this.filters = new TreeFilter[markTreeFilters.length];
        System.arraycopy(markTreeFilters, 0, this.filters, 0, markTreeFilters.length);
    }

    public int getMarks(TreeWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int marks = 0;
        for (int index = 0; index < this.filters.length; ++index) {
            TreeFilter filter = this.filters[index];
            if (filter == null) continue;
            try {
                boolean marked = filter.include(walk);
                if (!marked) continue;
                marks = (int)((long)marks | 1L << index);
                continue;
            }
            catch (StopWalkException e) {
                this.filters[index] = null;
            }
        }
        return marks;
    }
}

