/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.RepositoryNotFoundException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.PersonIdent;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.storage.pack.PackConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.DaemonClient;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.DaemonService;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.ReceivePack;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.ServiceMayNotContinueException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.UploadPack;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.resolver.RepositoryResolver;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.resolver.UploadPackFactory;

public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final ThreadGroup processors;
    private Acceptor acceptThread;
    private int timeout;
    private PackConfig packConfig;
    private volatile RepositoryResolver<DaemonClient> repositoryResolver;
    volatile UploadPackFactory<DaemonClient> uploadPackFactory;
    volatile ReceivePackFactory<DaemonClient> receivePackFactory;

    public Daemon() {
        this(null);
    }

    public Daemon(InetSocketAddress addr) {
        this.myAddress = addr;
        this.processors = new ThreadGroup("Git-Daemon");
        this.repositoryResolver = RepositoryResolver.NONE;
        this.uploadPackFactory = new UploadPackFactory<DaemonClient>(){

            @Override
            public UploadPack create(DaemonClient req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = new UploadPack(db);
                up.setTimeout(Daemon.this.getTimeout());
                up.setPackConfig(Daemon.this.getPackConfig());
                return up;
            }
        };
        this.receivePackFactory = new ReceivePackFactory<DaemonClient>(){

            @Override
            public ReceivePack create(DaemonClient req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                ReceivePack rp = new ReceivePack(db);
                InetAddress peer = req.getRemoteAddress();
                String host = peer.getCanonicalHostName();
                if (host == null) {
                    host = peer.getHostAddress();
                }
                String name = "anonymous";
                String email = name + "@" + host;
                rp.setRefLogIdent(new PersonIdent(name, email));
                rp.setTimeout(Daemon.this.getTimeout());
                return rp;
            }
        };
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            @Override
            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = Daemon.this.uploadPackFactory.create(dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                up.upload(in, out, null);
            }
        }, new DaemonService("receive-pack", "receivepack"){
            {
                this.setEnabled(false);
            }

            @Override
            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                ReceivePack rp = Daemon.this.receivePackFactory.create(dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                rp.receive(in, out, null);
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setRepositoryResolver(RepositoryResolver<DaemonClient> resolver) {
        this.repositoryResolver = resolver;
    }

    public void setUploadPackFactory(UploadPackFactory<DaemonClient> factory) {
        this.uploadPackFactory = factory != null ? factory : UploadPackFactory.DISABLED;
    }

    public ReceivePackFactory<DaemonClient> getReceivePackFactory() {
        return this.receivePackFactory;
    }

    public void setReceivePackFactory(ReceivePackFactory<DaemonClient> factory) {
        this.receivePackFactory = factory != null ? factory : ReceivePackFactory.DISABLED;
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        if (this.myAddress != null) {
            socket.bind(this.myAddress, 5);
        } else {
            socket.bind(new InetSocketAddress((InetAddress)null, 0), 5);
        }
        this.myAddress = (InetSocketAddress)socket.getLocalSocketAddress();
        this.acceptThread = new Acceptor(this.processors, "Git-Daemon-Accept", socket);
        this.acceptThread.start();
    }

    private synchronized void clearThread() {
        this.acceptThread = null;
    }

    public synchronized boolean isRunning() {
        return this.acceptThread != null && this.acceptThread.isRunning();
    }

    public synchronized void stop() {
        if (this.acceptThread != null) {
            this.acceptThread.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndWait() throws InterruptedException {
        Acceptor acceptor = null;
        Daemon daemon = this;
        synchronized (daemon) {
            acceptor = this.acceptThread;
            this.stop();
        }
        if (acceptor != null) {
            acceptor.join();
        }
    }

    void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        new Thread(this.processors, "Git-Daemon-Client " + peer.toString()){

            @Override
            public void run() {
                try {
                    dc.execute(s);
                }
                catch (ServiceNotEnabledException serviceNotEnabledException) {
                }
                catch (ServiceNotAuthorizedException serviceNotAuthorizedException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(DaemonClient client, String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open(client, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotAuthorizedException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }

    private class Acceptor
    extends Thread {
        private final ServerSocket listenSocket;
        private final AtomicBoolean running;

        public Acceptor(ThreadGroup group, String name, ServerSocket socket) {
            super(group, name);
            this.running = new AtomicBoolean(true);
            this.listenSocket = socket;
        }

        @Override
        public void run() {
            this.setUncaughtExceptionHandler((thread, throwable) -> this.terminate());
            while (this.isRunning()) {
                try {
                    Daemon.this.startClient(this.listenSocket.accept());
                }
                catch (SocketException socketException) {
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            this.terminate();
        }

        private void terminate() {
            try {
                this.shutDown();
            }
            finally {
                Daemon.this.clearThread();
            }
        }

        public boolean isRunning() {
            return this.running.get();
        }

        public void shutDown() {
            this.running.set(false);
            try {
                this.listenSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

