/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.FileSnapshot;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FS;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FileUtils;

public class LockFile {
    static final String SUFFIX = ".lock";
    static final FilenameFilter FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(LockFile.SUFFIX);
        }
    };
    private final File ref;
    private final File lck;
    private boolean haveLck;
    FileOutputStream os;
    private boolean needSnapshot;
    boolean fsync;
    private FileSnapshot commitSnapshot;

    public static boolean unlock(File file) {
        File lockFile = LockFile.getLockFile(file);
        int flags = 6;
        try {
            FileUtils.delete(lockFile, 6);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !lockFile.exists();
    }

    static File getLockFile(File file) {
        return new File(file.getParentFile(), file.getName() + SUFFIX);
    }

    @Deprecated
    public LockFile(File f, FS fs) {
        this.ref = f;
        this.lck = LockFile.getLockFile(this.ref);
    }

    public LockFile(File f) {
        this.ref = f;
        this.lck = LockFile.getLockFile(this.ref);
    }

    public boolean lock() throws IOException {
        FileUtils.mkdirs(this.lck.getParentFile(), true);
        if (FS.DETECTED.createNewFile(this.lck)) {
            this.haveLck = true;
            try {
                this.os = new FileOutputStream(this.lck);
            }
            catch (IOException ioe) {
                this.unlock();
                throw ioe;
            }
        }
        return this.haveLck;
    }

    public boolean lockForAppend() throws IOException {
        if (!this.lock()) {
            return false;
        }
        this.copyCurrentContent();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCurrentContent() throws IOException {
        this.requireLock();
        try (FileInputStream fis = new FileInputStream(this.ref);){
            if (this.fsync) {
                long r;
                FileChannel in = fis.getChannel();
                long pos = 0L;
                for (long cnt = in.size(); 0L < cnt; cnt -= r) {
                    r = this.os.getChannel().transferFrom(in, pos, cnt);
                    pos += r;
                }
            } else {
                int r;
                byte[] buf = new byte[2048];
                while ((r = fis.read(buf)) >= 0) {
                    this.os.write(buf, 0, r);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            if (this.ref.exists()) {
                this.unlock();
                throw fnfe;
            }
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (Error ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public void write(ObjectId id) throws IOException {
        byte[] buf = new byte[41];
        id.copyTo(buf, 0);
        buf[40] = 10;
        this.write(buf);
    }

    public void write(byte[] content) throws IOException {
        this.requireLock();
        try {
            if (this.fsync) {
                FileChannel fc = this.os.getChannel();
                ByteBuffer buf = ByteBuffer.wrap(content);
                while (0 < buf.remaining()) {
                    fc.write(buf);
                }
                fc.force(true);
            } else {
                this.os.write(content);
            }
            this.os.close();
            this.os = null;
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (Error ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public OutputStream getOutputStream() {
        this.requireLock();
        final OutputStream out = this.fsync ? Channels.newOutputStream(this.os.getChannel()) : this.os;
        return new OutputStream(){

            @Override
            public void write(byte[] b, int o, int n) throws IOException {
                out.write(b, o, n);
            }

            @Override
            public void write(byte[] b) throws IOException {
                out.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }

            @Override
            public void close() throws IOException {
                try {
                    if (LockFile.this.fsync) {
                        LockFile.this.os.getChannel().force(true);
                    }
                    out.close();
                    LockFile.this.os = null;
                }
                catch (IOException ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
                catch (RuntimeException ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
                catch (Error ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
            }
        };
    }

    void requireLock() {
        if (this.os == null) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotHeld, this.ref));
        }
    }

    public void setNeedStatInformation(boolean on) {
        this.setNeedSnapshot(on);
    }

    public void setNeedSnapshot(boolean on) {
        this.needSnapshot = on;
    }

    public void setFSync(boolean on) {
        this.fsync = on;
    }

    public void waitForStatChange() throws InterruptedException {
        FileSnapshot o = FileSnapshot.save(this.ref);
        FileSnapshot n = FileSnapshot.save(this.lck);
        while (o.equals(n)) {
            Thread.sleep(25L);
            this.lck.setLastModified(System.currentTimeMillis());
            n = FileSnapshot.save(this.lck);
        }
    }

    public boolean commit() {
        if (this.os != null) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotClosed, this.ref));
        }
        this.saveStatInformation();
        try {
            FileUtils.rename(this.lck, this.ref, StandardCopyOption.ATOMIC_MOVE);
            this.haveLck = false;
            return true;
        }
        catch (IOException e) {
            this.unlock();
            return false;
        }
    }

    private void saveStatInformation() {
        if (this.needSnapshot) {
            this.commitSnapshot = FileSnapshot.save(this.lck);
        }
    }

    public long getCommitLastModified() {
        return this.commitSnapshot.lastModified();
    }

    public FileSnapshot getCommitSnapshot() {
        return this.commitSnapshot;
    }

    public void createCommitSnapshot() {
        this.saveStatInformation();
    }

    public void unlock() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.haveLck) {
            this.haveLck = false;
            try {
                FileUtils.delete(this.lck, 2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "LockFile[" + this.lck + ", haveLck=" + this.haveLck + "]";
    }
}

