/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.ketch.KetchReplica;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Config;

public class ReplicaConfig {
    private KetchReplica.Participation participation = KetchReplica.Participation.FULL;
    private KetchReplica.CommitMethod commitMethod = KetchReplica.CommitMethod.ALL_REFS;
    private KetchReplica.CommitSpeed commitSpeed = KetchReplica.CommitSpeed.BATCHED;
    private long minRetry = TimeUnit.SECONDS.toMillis(5L);
    private long maxRetry = TimeUnit.MINUTES.toMillis(1L);

    public static ReplicaConfig newFromConfig(Config cfg, String name) {
        return new ReplicaConfig().fromConfig(cfg, name);
    }

    public KetchReplica.Participation getParticipation() {
        return this.participation;
    }

    public KetchReplica.CommitMethod getCommitMethod() {
        return this.commitMethod;
    }

    public KetchReplica.CommitSpeed getCommitSpeed() {
        return this.commitSpeed;
    }

    public long getMinRetry(TimeUnit unit) {
        return unit.convert(this.minRetry, TimeUnit.MILLISECONDS);
    }

    public long getMaxRetry(TimeUnit unit) {
        return unit.convert(this.maxRetry, TimeUnit.MILLISECONDS);
    }

    public ReplicaConfig fromConfig(Config cfg, String name) {
        this.participation = cfg.getEnum("remote", name, "ketch-type", this.participation);
        this.commitMethod = cfg.getEnum("remote", name, "ketch-commit", this.commitMethod);
        this.commitSpeed = cfg.getEnum("remote", name, "ketch-speed", this.commitSpeed);
        this.minRetry = ReplicaConfig.getMillis(cfg, name, "ketch-minRetry", this.minRetry);
        this.maxRetry = ReplicaConfig.getMillis(cfg, name, "ketch-maxRetry", this.maxRetry);
        return this;
    }

    private static long getMillis(Config cfg, String name, String key, long defaultValue) {
        String valStr = cfg.getString("remote", name, key);
        if (valStr == null) {
            return defaultValue;
        }
        if ((valStr = valStr.trim()).isEmpty()) {
            return defaultValue;
        }
        Matcher m = UnitMap.PATTERN.matcher(valStr);
        if (!m.matches()) {
            return defaultValue;
        }
        String digits = m.group(1);
        String unitName = m.group(2).trim();
        TimeUnit unit = UnitMap.UNITS.get(unitName);
        if (unit == null) {
            return defaultValue;
        }
        try {
            if (digits.indexOf(46) == -1) {
                return unit.toMillis(Long.parseLong(digits));
            }
            double val = Double.parseDouble(digits);
            return (long)(val * (double)unit.toMillis(1L));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static class UnitMap {
        static final Pattern PATTERN = Pattern.compile("^([1-9][0-9]*(?:\\.[0-9]*)?)\\s*(.*)$");
        static final Map<String, TimeUnit> UNITS;

        private UnitMap() {
        }

        static {
            HashMap<String, TimeUnit> m = new HashMap<String, TimeUnit>();
            TimeUnit u = TimeUnit.MILLISECONDS;
            m.put("", u);
            m.put("ms", u);
            m.put("millis", u);
            m.put("millisecond", u);
            m.put("milliseconds", u);
            u = TimeUnit.SECONDS;
            m.put("s", u);
            m.put("sec", u);
            m.put("secs", u);
            m.put("second", u);
            m.put("seconds", u);
            u = TimeUnit.MINUTES;
            m.put("m", u);
            m.put("min", u);
            m.put("mins", u);
            m.put("minute", u);
            m.put("minutes", u);
            u = TimeUnit.HOURS;
            m.put("h", u);
            m.put("hr", u);
            m.put("hrs", u);
            m.put("hour", u);
            m.put("hours", u);
            u = TimeUnit.DAYS;
            m.put("d", u);
            m.put("day", u);
            m.put("days", u);
            UNITS = Collections.unmodifiableMap(m);
        }
    }
}

